/*******************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 ******************************************************************************/

package com.day.cq.analytics.testandtarget.workspaces;

import com.day.cq.wcm.webservicesupport.Configuration;
import org.osgi.annotation.versioning.ProviderType;

import javax.annotation.Nonnull;

/**
 * The <code>TargetAccountTypeProvider</code> represents an interface to get the type of Adobe Target account - premium/standard.
 */
@ProviderType
public interface TargetAccountTypeProvider {

    /**
    * An enum of possible types of Target Accounts
    */
    public enum TargetAccountType{
        PREMIUM,
        STANDARD
    }

    /**
     * @param config Ims Target configuration
     * @throws WorkspacesConfigurationException if the Ims Target Configuration is invalid
     * @throws IllegalArgumentException  if the passed configuration is null
     * @return a String containing the the type of Adobe Target Account
     */
    TargetAccountType getTargetAccountType(@Nonnull Configuration config);
}
