/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 * 
 * Copyright 2024 Adobe
 * All Rights Reserved.
 * 
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/

package com.day.cq.commons.predicates;

import java.util.function.Predicate;

import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

/**
 * Predicate used to filter Folder nodes. Accepts rep:AuthorizableFolder nodes.
 */
@Component(
        service = Predicate.class,
        property = {
                "service.vendor=Adobe Systems Incorporated",
                "predicate.name=authorizablefolder"
        })
public class IsAuthorizableFolderPredicate implements NodePredicate {

    /**
     * default logger
     */
    private final Logger log = LoggerFactory.getLogger(IsAuthorizableFolderPredicate.class);

    /**
     * {@inheritDoc}
     *
     * @return <code>true</code> if node is an rep:AuthorizableFolder node.
     */
    @Override
    public boolean test(Node node) {
        try {
            return node.isNodeType("rep:AuthorizableFolder");
        } catch (RepositoryException e) {
            log.warn("RepositoryException in evaluate()", e);
        }
        return false;
    }

}