/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.commons.servlets;

import java.io.IOException;

import javax.servlet.ServletException;

import org.apache.felix.scr.annotations.Component;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Abstract servlet to use for the client/server command interface.
 *
 * Note: due to a problem in SCR plugin, this class cannot extend from the
 *       {@link AbstractPredicateServlet} because the predicate provider
 *       reference would be double defined.
 * @deprecated use {@link com.day.cq.commons.predicates.servlets.AbstractCommandServlet} instead
 */
@Deprecated
@Component(metatype = false, componentAbstract = true)
public abstract class AbstractCommandServlet extends AbstractPredicateServlet {

    private static final long serialVersionUID = -640576082673481348L;

    /**
     * default path parameter name
     */
    public static final String PATH_PARAM = "path";

    /**
     * default action parameter name
     */
    public static final String ACTION_PARAM = "cmd";

    private final Logger log = LoggerFactory.getLogger(AbstractCommandServlet.class);

    @Override
    @Deprecated
    protected void doPost(SlingHttpServletRequest request,
                          SlingHttpServletResponse response)
            throws ServletException, IOException {
        log.warn("AbstractCommandServlet POST method has been deprecated. Please use com.day.cq.commons.predicates.servlets.AbstractCommandServlet POST method instead.");
        if (this.hasCommand(request)) {
            this.performCommand(request, response);
        } else {
            handleMethodNotImplemented(request, response);
        }
    }

    @Override
    @Deprecated
    protected void doGet(SlingHttpServletRequest request,
                         SlingHttpServletResponse response)
            throws ServletException, IOException {
        log.warn("AbstractCommandServlet GET method has been deprecated. Please use com.day.cq.commons.predicates.servlets.AbstractCommandServlet GET method instead.");
        if (this.hasCommand(request)) {
            this.performCommand(request, response);
        } else {
            handleMethodNotImplemented(request, response);
        }
    }

    /**
     * Checks if the command in the request is supported.
     * Returns <code>false</code> by default.
     *
     * @param request servlet request
     * @return <code>true</code> if the command is supported.
     * @throws ServletException if a servlet error occurs
     * @deprecated
     */
    @Deprecated
    protected boolean hasCommand(SlingHttpServletRequest request)
            throws ServletException {
        return false;
    }

    /**
     * Perform the command of the current request.
     * This method is invoked if {@link #hasCommand(SlingHttpServletRequest)} returns <code>true</code>
     * for a POST request.
     *
     * @param request servlet request
     * @param response servlet response
     * @throws ServletException if an error occurs.
     * @throws IOException if an I/O error occurs.
     * @deprecated
     */
    @Deprecated
    abstract protected void performCommand(SlingHttpServletRequest request, SlingHttpServletResponse response)
            throws ServletException, IOException;

    /**
     * Get value of specified parameter, trim and verify that it's provided
     *
     * @param request the servlet request
     * @param name the name of the parameter
     *
     * @return the value of the parameter
     *
     * @throws ServletException if the parameter is missing or empty.
     * @deprecated
     */
    @Deprecated
    protected String requireParameter(SlingHttpServletRequest request, String name)
            throws ServletException {
        String val = request.getParameter(name);
        if (val != null) {
            val = val.trim();
        }
        if (val == null || val.length() == 0) {
            throw new ServletException("Missing request parameter '" + name + "'");
        }
        return val;
    }

}

