/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.commons.servlets;

import org.apache.sling.api.servlets.OptingServlet;

/**
 * {@linkplain NonExistingResourceServlet} is a specific servlet interface for servlets that need to handle non-existing
 * resources. Via the {@link #accepts(org.apache.sling.api.SlingHttpServletRequest)} method the implementing servlet
 * must check if it will handle the given non-existing path.
 * 
 * <p>
 * <b>Please note:</b> This is a <b>temporary solution</b> until Sling provides a built-in mechanism for this use case.
 * <b>Not to be used by client implementations!</b>
 * 
 * <p>
 * This servlet will not be registered directly with Sling but rather with a distinct dispatcher servlet that is
 * registered for the GET, HEAD, POST and PUT HTTP methods on the sling:nonexisting resource (
 * {@link NonExistingDispatcherServlet}).
 * 
 * <p>
 * To give a bit control over the order, set the standard OSGi property <code>service.ranking</code> (Integer) on the
 * servlet to define an integer value for the order - the implementations with the highest number are called first. The
 * first servlet that returns <code>true</code> in its {@link #accepts(org.apache.sling.api.SlingHttpServletRequest)}
 * method will handle the request.
 * 
 * <p>
 * Example code:
 * 
 * <pre>
 * {@literal @}Component
 * {@literal @}Service(NonExistingResourceServlet.class)
 * {@literal @}Property(name=&quot;service.ranking&quot;,intValue=10)
 *               
 * {@literal @}SuppressWarnings(&quot;serial&quot;)
 *  public class TesterServlet extends SlingAllMethodsServlet implements NonExistingResourceServlet {
 * 
 *      public boolean accepts(SlingHttpServletRequest request) {
 *          // get non-existing path (incl. selectors and extension!)
 *          String path = request.getResource().getPath();
 *          // return true if this servlet can handle this path
 *          return true;
 *      }
 *     
 *     {@literal @}Override
 *      protected void doGet(SlingHttpServletRequest request,
 *                  SlingHttpServletResponse response) throws ServletException,
 *                  IOException {
 *          // handle actual GET request here
 *          // ...
 *      }
 * </pre>
 * 
 */
public interface NonExistingResourceServlet extends OptingServlet {
    
}
