/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.dam.commons.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import javax.jcr.RepositoryException;

import com.adobe.granite.confmgr.Conf;

import org.apache.jackrabbit.api.security.user.User;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.resource.api.JcrResourceConstants;
import org.apache.sling.tenant.Tenant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.day.cq.commons.jcr.JcrConstants;
import com.day.cq.dam.api.DamConstants;
import com.day.cq.dam.commons.schemaforms.internal.TabList;
import com.day.text.Text;

/**
 * this is an internal class to be used by dam code.
 */
public class SchemaFormHelper {
	
	private static final Logger log = LoggerFactory.getLogger(SchemaFormHelper.class);

    /**
     * Given current form, returns a list of master.
     * Looks for master forms up in the path heirarchy,
     * while traversing it takes into account any override
     * available in apps
     *
     * @param currentForm current form resource
     * @return list of master form resource, empty list if no master is found
     * @throws RepositoryException
     * @deprecated Use getMasterForms(Resource resource) instead
     */
    @Deprecated
    public static List<Resource> getMasterForms(Resource currentForm, String formsBaseDirPath) throws RepositoryException {
        throw new UnsupportedOperationException("This API has been deprecated. Please use getMasterForms(Resource resource) instead.");
    }

    /**
     * @return Metadata Schema provides a OOTB form. And User can overlay this form as per use case.
     * It returns list of form path homes (Overlay, OOTB) in the order. e.g. [/conf/metdataschema, /libs/metadataschema]
     */
    public static String[] getBaseFormPaths(ResourceResolver resourceResolver){
        // SLING-7880 fixed the issue with some users like 'admin'
        Tenant tenant = resourceResolver.adaptTo(Tenant.class);
        return getBaseFormPathsFromTenant(resourceResolver, tenant);
    }

    private static String[] getBaseFormPathsFromTenant(ResourceResolver resourceResolver, Tenant tenant) {

        String schemaExtHome = (null != tenant)? (String)tenant.getProperty(DamConfigurationConstants.METADATA_SCHEMA_HOME) : DamConfigurationConstants.DEFAULT_METADATA_SCHEMA_HOME;
        String tenantAssetsRoot = (null != tenant)? (String)tenant.getProperty(DamConfigurationConstants.DAM_ASSETS_ROOT): DamConstants.MOUNTPOINT_ASSETS;
        String schemaHome = DamConfigurationConstants.OOTB_METADATA_SCHEMA_FORM_HOME;
        Resource schemaExtHomeRes = resourceResolver.getResource(schemaExtHome);
        if(null == schemaExtHome || schemaExtHome.trim().isEmpty() || schemaExtHomeRes == null){
            schemaExtHome = DamConfigurationConstants.DEFAULT_METADATA_SCHEMA_HOME;
        }else{
            Conf conf = resourceResolver.getResource(tenantAssetsRoot).adaptTo(Conf.class);
            if(conf != null) {
                schemaHome = conf.getItem(DamConfigurationConstants.ADMIN_UI_OOTB_CONF_RELPATH)
                    .get(DamConfigurationConstants.METADATA_SCHEMA_HOME, DamConfigurationConstants.OOTB_METADATA_SCHEMA_FORM_HOME);
            }
        }
        return new String[]{schemaExtHome, schemaHome};
    }

    /**
     * retruns relatibe path of the form '/default/image'
     * @param formPath
     * @param baseFormPaths
     * @return
     */
    private static String getRelativeFormPath(String formPath, String[] baseFormPaths){
        for(String baseFormPath : baseFormPaths){
            if (formPath.startsWith(baseFormPath)){
                String relativePath = formPath.substring(baseFormPath.length());
                relativePath = relativePath.startsWith("/") ? relativePath : relativePath + "/";
                relativePath = relativePath.endsWith("/") ? relativePath.substring(relativePath.length() -1 ) : relativePath;
                return relativePath;
            }
        }
        return formPath;
    }

    /**
     * Given current form, returns a list of master.
     * Looks for master forms up in the path heirarchy,
     * while traversing it takes into account any override
     * available in apps
     *
     * @param currentForm current form resource
     * @return list of master form resource, empty list if no master is found
     * @throws RepositoryException
     * @throws java.lang.NullPointerException
     * @deprecated Use getPrimaryForms(Resource resource) instead
     */
    public static List<Resource> getMasterForms(Resource currentForm) throws RepositoryException {
       log.warn("This API has been deprectaed.Please use Use getPrimaryForms(Resource resource) instead");
       return getPrimaryForms(currentForm);
        
    }
    
    /**
     * Given current form, returns a list of primary.
     * Looks for primary forms up in the path heirarchy,
     * while traversing it takes into account any override
     * available in apps
     *
     * @param currentForm current form resource
     * @return list of primary form resource, empty list if no primary is found
     * @throws RepositoryException
     * @throws java.lang.NullPointerException
     */
    public static List<Resource> getPrimaryForms(Resource currentForm) throws RepositoryException {
        ResourceResolver resourceResolver = currentForm.getResourceResolver();
        String[] baseFormPaths = getBaseFormPathsFromTenant(resourceResolver, currentForm.adaptTo(Tenant.class));
        String relativePath = getRelativeFormPath(currentForm.getPath(), baseFormPaths);
        List<Resource> primaryFormsList = new ArrayList<Resource>();
        relativePath = relativePath.trim().isEmpty() ? "" : relativePath.substring(0, relativePath.lastIndexOf('/'));

        while(!relativePath.trim().isEmpty()){
            for(int i=0; i<baseFormPaths.length; i++){
                String baseFormPath = baseFormPaths[i];
                Resource resToVerify = resourceResolver.getResource(baseFormPath + relativePath);
                if(resToVerify != null && (i == baseFormPaths.length -1 ||  resToVerify.getChild("items/tabs") != null)){
                    primaryFormsList.add(resToVerify);
                    break;
                }
            }
            relativePath = relativePath.trim().isEmpty() ? "" : relativePath.substring(0, relativePath.lastIndexOf('/'));
        }

        Collections.reverse(primaryFormsList);
        return primaryFormsList;
    }



    /**
     * Merge two list of tabs i.e. form/items/tabs
     *
     * @param oneTabList   resource representing one tab list
     * @param otherTabList resource representing other tab list
     * @return merged tab list resource
     */
    public static Resource mergeFormTabResource(Resource oneTabList, Resource otherTabList) {
        if (oneTabList == null) {
            return otherTabList;
        }

        if (otherTabList == null) {
            return oneTabList;
        }

        TabList aTab = new TabList(oneTabList);
        TabList oTab = new TabList(otherTabList);

        aTab.merge(oTab);

        return aTab;
    }

    public static Resource getSchemaResource(SlingHttpServletRequest request) {
        String suffix = request.getRequestPathInfo().getSuffix();
        suffix = suffix == null ? "" : suffix;
        ResourceResolver resourceResolver = request.getResourceResolver();
        String[] baseFormPaths = getBaseFormPaths(resourceResolver);
        for(String baseFormPath : baseFormPaths){
            Resource res = resourceResolver.getResource(baseFormPath + suffix);
            if(null != res){
                return res;
            }
        }
        return null;
    }

    private static String getAppsDir(ResourceResolver resolver) {
    	String appsDir = DamConstants.APPS;
    	
    	// Tenantification of apps directory
    	Tenant tenant = resolver.adaptTo(Tenant.class);
    	if (tenant != null) {
    		appsDir = appsDir + "/" + tenant.getId();
    	}
    	
    	return appsDir;
    }

    public static Iterator getSchemaFormsIterator(SlingHttpServletRequest request, int rows, int offset) {
        // rows and offset will be required in case we want infinite scrolling in the future
    	return getSchemaFormsIterator(request.getResourceResolver(), request.getRequestPathInfo().getSuffix(), rows, offset);
    }
    
    public static Iterator getSchemaFormsIterator(ResourceResolver resolver, String suffix, int rows, int offset){
    	List<Resource> resourceList = new ArrayList<Resource>();

        String[] baseFormPaths = getBaseFormPaths(resolver);

        suffix = null == suffix ? "" : suffix;
        suffix = getRelativeFormPath(suffix, baseFormPaths);
        //create a concatenated tree out of APPS_DIR & LIBS_DIR
        String appsResPath = baseFormPaths[0] + suffix;
        String libsResPath = baseFormPaths[1] + suffix;

        Resource appRes = resolver.getResource(appsResPath);
        Resource libsRes = resolver.getResource(libsResPath);

        // fill all the resources in /apps which are not in /libs
        if (appRes != null) {
            for (Iterator<Resource> appIter = appRes.listChildren(); appIter.hasNext(); ) {
                Resource ar = appIter.next();
                String resName = Text.getName(ar.getPath());

                if (libsRes == null || libsRes.getChild(resName) == null) {
                    if (ar.isResourceType(JcrConstants.NT_FOLDER) ||
                            ar.isResourceType(JcrResourceConstants.NT_SLING_ORDERED_FOLDER) ||
                            ar.isResourceType(JcrResourceConstants.NT_SLING_FOLDER))
                        resourceList.add(ar);
                }
            }
        }

        // for all resources common in /apps and /libs, take those that are in /apps
        // else take those that are in /libs
        if (libsRes != null) {
            for (Iterator<Resource> libsIter = libsRes.listChildren(); libsIter.hasNext(); ) {
                Resource lr = libsIter.next();
                String resName = Text.getName(lr.getPath());

                if (appRes != null && appRes.getChild(resName) != null && appRes.getChild(resName).getChild("items/tabs") != null) {
                    Resource ar = resolver.getResource(appRes.getPath() + "/" + resName);
                    if (ar.isResourceType(JcrConstants.NT_FOLDER) ||
                            ar.isResourceType(JcrResourceConstants.NT_SLING_ORDERED_FOLDER) ||
                            ar.isResourceType(JcrResourceConstants.NT_SLING_FOLDER)) {
                        resourceList.add(ar);
                    }
                } else {
                    if (lr.getChild("items/tabs") != null && lr.isResourceType(JcrConstants.NT_FOLDER) ||
                            lr.isResourceType(JcrResourceConstants.NT_SLING_ORDERED_FOLDER) ||
                            lr.isResourceType(JcrResourceConstants.NT_SLING_FOLDER))
                        resourceList.add(lr);
                }
            }
        }
        return resourceList.iterator();
    }

}
