package com.day.cq.dam.commons.watermark;

import com.day.image.Layer;

import java.awt.image.BufferedImage;

/**
 *  A {@link ImageWatermark} represents an image to be used to watermark an underlying image.<br>
 */
public class ImageWatermark extends Watermark {

    BufferedImage image;

    public ImageWatermark() {
    }

    public ImageWatermark(BufferedImage image) {
        this.image = image;
    }

    public ImageWatermark(int top, int left, double orientation, float opacity, BufferedImage image) {
        super(top, left, orientation, opacity);
        this.image = image;
    }

    public ImageWatermark(Location position, BufferedImage image) {
        super(position);
        this.image = image;
    }

    public ImageWatermark(int top, int left, BufferedImage image) {
        super(top, left);
        this.image = image;
    }

    public ImageWatermark(Location position, double orientation, float opacity) {
        super(position, orientation, opacity);
    }

    public ImageWatermark(int top, int left, double orientation, float opacity) {
        super(top, left, orientation, opacity);
    }

    public ImageWatermark(Location position) {
        super(position);
    }

    public ImageWatermark(int top, int left) {
        super(top, left);
    }

    public BufferedImage getImage() {
        return image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }
}
