/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.dam.commons.xml;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

public class DocumentBuilderFactoryProvider implements SecureDocumentBuilderFactory {

    private DocumentBuilderFactory createDBFInstance() throws ParserConfigurationException {
        return DocumentBuilderFactory.newInstance();
    }
    private DocumentBuilderFactory configureDBFInstance(DocumentBuilderFactory dbf,
                                                        Boolean setNameSpaceAware, Boolean setValidating) throws ParserConfigurationException {

        if(setNameSpaceAware) {
            dbf.setNamespaceAware(true);
        }

        if(setValidating) {
            dbf.setValidating(true);

            // validate document against DTD
            dbf.setFeature("http://xml.org/sax/features/validation", true);
        }

        // do not expand entity reference nodes
        dbf.setExpandEntityReferences(false);

        // do not include external general entities
        dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);

        // do not include external parameter entities or the external DTD subset
        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);

        // build the grammar but do not use the default attributes and attribute types information it contains
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);

        // ignore the external DTD completely
        dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        return dbf;
    }
    public DocumentBuilderFactory createSecureBuilderFactory(Boolean setNameSpaceAware) throws ParserConfigurationException {
        // validate document while parsing it
        return configureDBFInstance(createDBFInstance(), setNameSpaceAware, true);
    }
    public DocumentBuilderFactory createSecureBuilderFactory(Boolean setNameSpaceAware, Boolean setValidating) throws ParserConfigurationException {
        return configureDBFInstance(createDBFInstance(), setNameSpaceAware, setValidating);
    }
}
