/*************************************************************************
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright Sep 14, 2016 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by all applicable intellectual property
* laws, including trade secret and copyright laws.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/

package com.day.cq.dam.scene7.api;

import java.util.List;
import java.util.Map;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import org.osgi.annotation.versioning.ProviderType;

import com.day.cq.dam.scene7.api.model.Scene7Asset;

@ProviderType
public interface Scene7AssetFactory {
    
 // trash state of the deleted assets in Scene7
    static final String TRASH_STATE = "InTrash";
    
    /**
     * Processes the <code>Document</code> and builds a list of <code>Scene7Asset</code> objects that the document contains
     * 
     * @param document
     *            Document object containing the Scene7 assets
     * @return a List of <code>Scene7Asset</code> objects
     */
    public List<Scene7Asset> parseAssets(Document document);
    
    /**
     * Builds a <code>Scene7Asset</code> object from the <code>Element</code> object received as a parameter
     * 
     * @param element
     *            <code>Element</code> object containing a Scene7 asset
     * @return <code>Scene7Asset</code> object
     */
    public Scene7Asset parseAsset(Element element);
    
    /**
     * Attempts to parse the originator asset for a Scene7 asset that supports
     * sub assets
     * 
     * @param asset
     *            <code>Scene7Asset</code> asset capable of supporting
     *            sub-assets
     * @param associatedAssetsDocument
     *            <code>Document</code> object containing the sub assets and the originator asset
     * @return the <code>Scene7Asset</code> object updated with the parsed
     *         sub-assets and the originator asset If the
     *         <code>Scene7Asset</code> asset object does not support sub-assets, the object will not be touched
     * 
     */
    public Scene7Asset parseMasterAssets(Scene7Asset asset,
            Document associatedAssetsDocument);
    
    /**
     * Attempts to parse the originator asset and sub assets for a Scene7 asset that supports sub assets
     * 
     * @param asset
     *            <code>Scene7Asset</code> asset capable of supporting sub-assets
     * @param associatedAssetsDocument
     *            <code>Document</code> object containing the sub assets and the originator asset
     * @return the <code>Scene7Asset</code> object updated with the parsed sub-assets and the originator asset If the
     *         <code>Scene7Asset</code> asset object does not support sub-assets, the object will not be touched
     * 
     */
    public Scene7Asset parseSubAssets(Scene7Asset asset,
            Document associatedAssetsDocument);

    /**
     * Creates a new <code>Scene7Asset</code> object
     * 
     * @param assetAttributes
     *            a <code>Map</code> object containing the new Scene7 asset's
     *            main attributes
     */
    public Scene7Asset createAsset(Map<Object, Object> assetAttributes);

}
