/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2020 Adobe
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.day.cq.dam.scene7.api.model;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

import com.day.cq.dam.scene7.api.constants.Scene7PublishMode;
@ProviderType
public interface Scene7PublishStatus {

    /**
     * Get the principal who published the asset
     *
     * @return principal representing the user who published the asset
     */
    String getPublishedBy();

    /**
     * Get the publish status - possible values are {@link com.day.cq.dam.scene7.api.constants.Scene7Constants#PV_S7_PUBLISH_COMPLETE}
     * and {@link com.day.cq.dam.scene7.api.constants.Scene7Constants#PV_S7_PUBLISH_INCOMPLETE}
     *
     * @return scene7FileStatus
     */
    String getPublishAction();

    /**
     * Get the publish mode for this asset
     *
     * @return A <code>Scene7PublishMode</code> identifying the publish mode for this asset
     */
    Scene7PublishMode getPublishMode();

    /**
     * Get the publish date 
     *
     * @return <code>java.util.Date</code> representing the publish date
     */
    Date getPublishTimestamp();
    
}
