/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.mailer;

import com.adobe.granite.security.user.UserProperties;
import org.apache.jackrabbit.api.security.user.Authorizable;

import javax.jcr.RepositoryException;

/**
 * MessageTemplate it the template a Message of a Mailing is build of.
 * It must be able to build a Message for each recipient.
 * The Message has to be in the format that is able to be send by a
 * {@link MessageGateway MessageGateway}. <br>
 * As MessageTemplates are likely to access resources, that have a state.
 * Eg. a Session to the Repository, Binary Values or Database access.
 * Therefore the template must be disposed if there is no further use for it.
 *
 * @see com.day.cq.mailer.impl.Mailing
 * @since 5.4
 */
public interface MessageTemplate<Type> {

    /**
     * @return indicate the Type the message will be build
     */
    Class<Type> getType();

    /**
     * Builds a personalized message for the
     * {@link Authorizable recipient} given as argument.
     * <br>
     * In case the Template has been {@link #dispose() disposed} an
     * {@link IllegalStateException IllegalStateException} is thrown.
     *
     * @param recipient to build a message for
     * @param userProperties used to build the message for the recipient.

     * @return the message for the given recipient or <code>null</code> if the
     *          MailingRecipient does not provide sufficient data to build a
     *          Message (eg. no e-mail address to build a e-mail Message)
     * @throws MailingException in case of an error building the message that is
     *         independent of the MailingRecipient eg. access to template storage
     *         is in exceptional state.
     * @throws IllegalStateException in case {@link #dispose() method dispose} has been called before.
     * @throws RepositoryException If an error occurs.
     */

    Type buildMessage(Authorizable recipient, UserProperties userProperties) throws MailingException, RepositoryException;

    /**
     * Called if the Template will not be used any longer.
     * A subsequent call to {@link #buildMessage(Authorizable, UserProperties) buildMessage}
     * will fail.
     * Implementations can dispose any used Resources eg.
     * {@link javax.jcr.Binary Binary Values}, Database access.
     * @throws MailingException in case of exception disposing one of the resources
     */
    void dispose() throws MailingException;

    /**
     * Adds or overwrites a mapping of this replacer.
     * @param var name of the variable to map
     * @param replace the value of the variable
     */
   void put(String var, String replace);
}
