/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.mcm.emailprovider;


import com.day.cq.mcm.emailprovider.types.EmailServiceActions;
import com.day.cq.wcm.webservicesupport.Configuration;

import java.util.Map;

/**
 * This is a provider interface that needs to be implemented for integration of external email providers with CQ.
 */
public interface EmailService {
    /**
     * Every email provider will be identified by a name. This method should return the name of the email provider.
     * This name should be part of the cloud service configuration (as providerName property) so that it can be used
     * to identify the email provider implementation associated with the cloud service configuration.
     * @return The name of the email provider.
     */
    public String getName();
    
    /**
     * 
     * @param op The operation to be performed by the email service provider
     * @param params	parameters needed for the operation
     * @return An object, typically converted to JSON needed for configurations on client side
     *  or NULL if the operation is not about configuration. The following can be expected as return: a List<Object> corresponding to JSONArray, a Map<String,Object>
     *  corresponding to JSONObject or just an Object depending on the operation. Note the List can contain another List<Object>, Map<String,Object> or Object and the Map can contain another 
     *  List, Map or Object as Value of key.
     * @throws EmailServiceException
     */
    public Object execute(EmailServiceActions op,Map<String,Object> params, Configuration config) throws EmailServiceException;

}
