/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2011 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/

package com.day.cq.replication;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;

/**
 * Represents an outbox that will return new items on this instance,
 * automatically removing items older than the timestamp given.
 */
public interface Outbox {

    /**
     * Put item in the outbox.
     *
     * @param action replication action, must not be {@link com.day.cq.replication.ReplicationActionType#ACTIVATE}
     * @param in item data
     * @throws ReplicationException if an error occurs
     */
    void put(ReplicationAction action, InputStream in) throws ReplicationException;

    /**
     * Put an empty item in the outbox with a replication action other than
     * {@link com.day.cq.replication.ReplicationActionType#ACTIVATE}.
     *
     * @param action replication action, must not be {@link com.day.cq.replication.ReplicationActionType#ACTIVATE}
     * @throws ReplicationException if an error occurs
     */
    void put(ReplicationAction action) throws ReplicationException;

    /**
     * Fetch items from the outbox, having a last modified time greater than
     * the given optional time, automatically removing items that are older.
     *
     * @param time if not <code>null</code>, all items older than this date
     *             are automatically purged from the outbox before returning the
     *             outbox's content
     * @param out output stream where to store a virtual durbo package named
     *            <code>outbox</code> with the items in the outbox as children
     * @throws ReplicationException if an error occurs
     */
    void fetch(Calendar time, OutputStream out) throws ReplicationException;

    /**
     * Returns the outbox path.
     * @return the outbox path.
     */
    String getPath();
}
