/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.rewriter.htmlparser;

import java.util.Iterator;

/**
 * Contains the list of attributes inside an HTML tag.
 * @deprecated This is replaced by the Apache Sling Html parsing.
 */
@Deprecated
public interface AttributeList {

    /**
     * Return the count of attributes
     * @return count of attributes
     */
    int attributeCount();

    /**
     * Return the list of attribute names
     * @return <code>Iterator</code> iterating over the attribute names
     */
    Iterator<String> attributeNames();

    /**
     * Return a flag indicating whether a specified attribute exists
     * @param name name of the attribute
     * @return <code>true</code> if the specified attribute exists,
     * <code>false</code> otherwise
     */
    boolean containsAttribute(String name);

    /**
     * Return an attribute's value, given its name or <code>null</code>
     * if the attribute cannot be found.
     * @param name   attribute name
     * @return an attribute's value
     */
    String getValue(String name);

    /**
     * Return an attribute's quote character, given its name or <code>0</code>
     * if the attribute cannot be found.
     * @param name   attribute name
     * @return an attribute's quote character
     */
    char getQuoteChar(String name);

    /**
     * Return an attribute's value, already surrounded with the quotes
     * originally in place. Returns <code>null</code> if the attribute
     * cannot be found
     * @param name   attribute name
     * @return an attribute's value
     */
    String getQuotedValue(String name);

    /**
     * Set an attribute's value. If the value is <code>null</code>, this
     * is semantically different to a {@link #removeValue(String)}.
     *
     * @param name      attribute name
     * @param value     attribute value
     */
    void setValue(String name, String value);

    /**
     * Remove an attribute's value.
     * @param name      attribute name
     */
    void removeValue(String name);

    /**
     * Return a flag indicating whether this object was modified.
     * @return <code>true</code> if the object was modified
     *         <code>false</code> otherwise
     */
    boolean isModified();

}
