/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.security.privileges;

/**
 * A Privilege is a permission that is granted a given
 * {@link com.day.cq.security.Authorizable Authorizable}.
 * A Privilege is right, that is independant of a particular
 * {@link javax.jcr.Item Item-independant}.
 * Rights of Items are granted and enforced on by the
 * {@link javax.jcr.Repository Repository}.
 * It is still possible that the validity of a Privilege is restricted on
 * pathes within the Repository. In this case the Privilege is
 * {@link com.day.cq.security.privileges.Privilege#isPathDependent()} path depoendent}.
 *
 * @see com.day.cq.security.privileges.PrivilegeFactory
 * @deprecated CQ 5.5
 */
public interface Privilege {

    /**
     * <p>getID.</p>
     *
     * @return the ID of the current Privilege, should be a relative path
     */
    String getID();

    /**
     * <p>isPathDependent.</p>
     *
     * @return if the privilege is different for different repository locations
     */
    boolean isPathDependent();

    /**
     * <p>isGranted.</p>
     *
     * @param path repository path or <code>null</code> if this Privilege is
     *        {@link #isPathDependent() is path independent}
     * @return <code>true</code> if the privilige is granted on the given path
     *         or if the Privilege is path indedpendent
     */
    boolean isGranted(String path);
}
