/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 * **************************************************************************/

package com.day.cq.wcm.command.api;

import org.osgi.annotation.versioning.ProviderType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * interface to build {@code CopyMoveCommandPathArgument}
 */
@ProviderType
public interface CopyMoveCommandPathArgumentBuilder extends CommandPathArgumentBuilder {

    /**
     * set source path of the selected item
     *
     * @param srcPath path of the selected item
     * @return this {@code CopyMoveCommandPathArgumentBuilder}
     */
    @Nonnull
    CopyMoveCommandPathArgumentBuilder withSrcPath(@Nonnull String srcPath);

    /**
     * set destination path of the selected item
     *
     * @param dstPath path of the selected item
     * @return this {@code CopyMoveCommandPathArgumentBuilder}
     */
    @Nonnull
    CopyMoveCommandPathArgumentBuilder withDstPath(@Nonnull String dstPath);

    /**
     * set reference paths of the selected item
     *
     * @param adjustRefPaths reference paths of the selected item
     * @return this {@code CopyMoveCommandPathArgumentBuilder}
     */
    @Nonnull
    CopyMoveCommandPathArgumentBuilder withAdjustRefPaths(@Nullable String[] adjustRefPaths);

    /**
     * set publish paths referenced in the selected item
     *
     * @param publishPaths publish paths referenced in the selected item
     * @return this {@code CopyMoveCommandPathArgumentBuilder}
     */
    @Nonnull
    CopyMoveCommandPathArgumentBuilder withPublishPaths(@Nullable String[] publishPaths);

}
