/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/
package com.day.cq.wcm.commons.policy;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import com.day.cq.wcm.api.designer.Cell;
import com.day.cq.wcm.api.designer.Design;
import com.day.cq.wcm.api.designer.Style;
import com.day.cq.wcm.api.policies.ContentPolicy;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;

/**
 * A compatibility wrapper using a content policy as a style.
 *
 * The goal is to use components using the currentStyle binding with the new content policies, without the need
 * to change the component. This will not be a complete style implementation but rather focuses on the reading
 * of the  map values.
 *
 * @since 6.1
 */
public class ContentPolicyStyle implements Style {

    private final ContentPolicy contentPolicy;

    private final Cell cell;

    private ValueMap properties;

    public ContentPolicyStyle(ContentPolicy contentPolicy, Cell cell) {
        if (contentPolicy == null) {
            throw new IllegalArgumentException("contentPolicy is null");
        }
        this.contentPolicy = contentPolicy;
        this.cell = cell;
    }

    private void initProperties() {
        if (properties == null) {
            properties = contentPolicy.getProperties();
            if (properties == null) {
                properties = new ValueMapDecorator(new HashMap<String, Object>());
            }
        }
    }

    public Design getDesign() {
        //content policies are not related to designs anymore.
        return null;
    }

    public String getPath() {
        return contentPolicy.getPath();
    }

    public Cell getCell() {
        return cell;
    }

    public <T> T get(String name, Class<T> type) {
        initProperties();
        return properties.get(name, type);
    }

    public <T> T get(String name, T defaultValue) {
        initProperties();
        return properties.get(name, defaultValue);
    }

    public Resource getDefiningResource(String name) {
        return null;
    }

    public String getDefiningPath(String name) {
        return null;
    }

    public Style getSubStyle(String relPath) {
        return null;
    }

    public int size() {
        initProperties();
        return properties.size();
    }

    public boolean isEmpty() {
        initProperties();
        return properties.isEmpty();
    }

    public boolean containsKey(Object o) {
        initProperties();
        return properties.containsKey(o);
    }

    public boolean containsValue(Object o) {
        initProperties();
        return properties.containsValue(o);
    }

    public Object get(Object o) {
        initProperties();
        return properties.get(o);
    }

    public Object put(String s, Object o) {
        initProperties();
        return properties.put(s, o);
    }

    public Object remove(Object o) {
        initProperties();
        return properties.remove(o);
    }

    public void putAll(Map<? extends String, ?> map) {
        initProperties();
        properties.putAll(map);
    }

    public void clear() {
        initProperties();
        properties.clear();
    }

    public Set<String> keySet() {
        initProperties();
        return properties.keySet();
    }

    public Collection<Object> values() {
        initProperties();
        return properties.values();
    }

    public Set<Entry<String, Object>> entrySet() {
        initProperties();
        return properties.entrySet();
    }
}
