/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ~ Copyright 2016 Adobe Systems Incorporated
 ~
 ~ Licensed under the Apache License, Version 2.0 (the "License");
 ~ you may not use this file except in compliance with the License.
 ~ You may obtain a copy of the License at
 ~
 ~     http://www.apache.org/licenses/LICENSE-2.0
 ~
 ~ Unless required by applicable law or agreed to in writing, software
 ~ distributed under the License is distributed on an "AS IS" BASIS,
 ~ WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 ~ See the License for the specific language governing permissions and
 ~ limitations under the License.
 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

package com.day.cq.wcm.foundation.forms;


import org.apache.sling.api.resource.Resource;

/**
 * Interface to provide instances of {@link FormStructureHelper}
 */
public interface FormStructureHelperFactory {

    /**
     * Returns a {@link FormStructureHelper} which can manage the passed resource. In case multiple
     * implementations of {@link FormStructureHelper} are available, highest ranked {@link FormStructureHelper}
     * will be returned.
     * @param resource {@link Resource} can be form node or a form field node. See
     * {@link FormStructureHelper#canManage(Resource)}.
     * @return {@link FormStructureHelper}
     */
    FormStructureHelper getFormStructureHelper(Resource resource);

}
