/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.workflow.compatibility;

import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.job.AbsoluteTimeoutHandlerProxy;
import com.day.cq.workflow.impl.exec.CQWorkItemWrapper;
import com.day.cq.workflow.job.AbsoluteTimeoutHandler;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.References;
import org.apache.felix.scr.annotations.Service;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

/**

 */



@Component(metatype = false, label = "%cq.workflow.compat.absolutetimeoutproxy.name", description = "%cq.workflow.compat.absolutetimeoutproxy.description")
@Property(name = "service.description", value="%cq.workflow.compat.absolutetimeoutproxy.description")
@References({
        @Reference(name = "AbsoluteTimeoutHandler", cardinality = ReferenceCardinality.OPTIONAL_MULTIPLE, referenceInterface = AbsoluteTimeoutHandler.class, policy = ReferencePolicy.DYNAMIC)
})
@Service
public class AbsoluteTimeoutHandlerProxyImpl implements AbsoluteTimeoutHandlerProxy {

    protected List<AbsoluteTimeoutHandler> timeoutHandlers = new CopyOnWriteArrayList<AbsoluteTimeoutHandler>();

    public void bindAbsoluteTimeoutHandler(AbsoluteTimeoutHandler timeoutHandler) {
        timeoutHandlers.add(timeoutHandler);
    }

    public void unbindAbsoluteTimeoutHandler(AbsoluteTimeoutHandler timeoutHandler) {
        timeoutHandlers.remove(timeoutHandler);
    }

    public boolean canExecute(String handlerName) {
        if (timeoutHandlers != null) {
            for(AbsoluteTimeoutHandler handler : timeoutHandlers) {
                if (handler.getClass().getCanonicalName().equals(handlerName)) {
                    return true;
                }
            }
        }
        return false;
    }

    public long getTimeoutDate(WorkItem workItem) {
        return 0;  //To change body of implemented methods use File | Settings | File Templates.
    }

    public com.adobe.granite.workflow.job.AbsoluteTimeoutHandler findHandler(String handlerName) {
        if (timeoutHandlers != null) {
            for(AbsoluteTimeoutHandler handler : timeoutHandlers) {
                if (handler.getClass().getCanonicalName().equals(handlerName)) {
                    return new AbsoluteTimeoutHandlerWrapper(handler);
                }
            }
        }
        return null;
    }

    class AbsoluteTimeoutHandlerWrapper implements com.adobe.granite.workflow.job.AbsoluteTimeoutHandler {

        private AbsoluteTimeoutHandler handler;

        public AbsoluteTimeoutHandlerWrapper(AbsoluteTimeoutHandler handler) {
            this.handler = handler;
        }

        public long getTimeoutDate(WorkItem workItem) {
            return handler.getTimeoutDate(new CQWorkItemWrapper(workItem));
        }
    }
}
