/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.workflow.exec.filter;

import com.day.cq.workflow.exec.WorkItem;

/**
 * The <code>WorkItemFilter</code> interface allows filter implementations
 * that can be used to filter specific <code>{@link WorkItem}s</code>
 */
public interface WorkItemFilter {
    /**
     * This method returns <code>true</code> if the given <code>{@link WorkItem}</code>
     * matches the filter criteria.
     *
     * @param workItem <code>{@link WorkItem}</code> to check
     *
     * @return <code>true</code> if the given <code>{@link WorkItem}</code>
     * matches the filter criteria.
     */
    boolean doInclude(WorkItem workItem);
}
