/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.workflow.launcher;

import java.util.List;


/**
 * The <code>ConfigEntry</code> represents <i>one</i> workflow launcher 
 * configuration entry
 */
public class ConfigEntry {
    private String nodetype;
    private String whereClause;
    private int eventType;
    private String glob;
    private String workflow;
    private String id;
    private String description;
    private boolean enabled;
    private List<String> excludeList;
    private List<String> runModes;
    
    public ConfigEntry(int eventType, String glob, String nodetype,
                       String whereClause, String workflow, String id,
                       String description, boolean enabled,
                       List<String> excludeList, List<String> runModes) {
        this.eventType = eventType;
        this.glob = glob;
        this.nodetype = nodetype;
        this.whereClause = whereClause;
        this.workflow = workflow;
        this.id = id;
        this.description = description;
        this.enabled = enabled;
        this.excludeList = excludeList;
        this.runModes = runModes;
    }

    public String getWorkflow() {
        return workflow;
    }

    public void setWorkflow(String actionClassScript) {
        this.workflow = actionClassScript;
    }

    public int getEventType() {
        return eventType;
    }

    public void setEventType(int eventType) {
        this.eventType = eventType;
    }

    public String getGlob() {
        return glob;
    }

    public void setGlob(String glob) {
        this.glob = glob;
    }

    public String getNodetype() {
        return nodetype;
    }

    public void setNodetype(String nodetype) {
        this.nodetype = nodetype;
    }

    public String getWhereClause() {
        return whereClause;
    }

    public void setWhereClause(String whereClause) {
        this.whereClause = whereClause;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }


    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int hashCode() {
        String code = String.valueOf(eventType) + nodetype + whereClause + glob + workflow;
        return code.hashCode();
    }


    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }


    public List<String> getExcludeList() {
        return excludeList;
    }

    public void setExcludeList(List<String> excludeList) {
        this.excludeList = excludeList;
    }

    public List<String> getRunModes() {
        return this.runModes;
    }

    public void setRunModes(List<String> runModes) {
        this.runModes = runModes;
    }
}
