/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 1997 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.day.crx;

import javax.jcr.Repository;

/**
 * Lifecycle listener interface for repository startup and shutdown.
 */
public interface RepositoryLifecycleListener {

    /**
     * Called when a repository has been fully started.
     *
     * @param repository repository that has been fully started.
     */
    void started(Repository repository);

    /**
     * Called when a repository is about to be shut down.
     *
     * @param repository repository that is about to be shut down
     */
    void shuttingDown(Repository repository);

    /**
     * Called when a repository has been completely shut down.
     *
     * @param repository repository that has been shut down.
     */
    void shutdown(Repository repository);

}
