/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 1997 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
package com.day.crx.statistics;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * <code>PathBuilder</code> is a base class for path builders.
 *
 * @author mreutegg
 */
public class PathBuilder {

    /**
     * Format the time stamp of a {@link Entry} with this {@link DateFormat}.
     */
    private final DateFormat timestampFormat;

    /**
     * Creates a new {@link PathBuilder}.
     *
     * @param timestampPattern a date pattern.
     */
    public PathBuilder(String timestampPattern) {
        this.timestampFormat = new SimpleDateFormat(timestampPattern);
    }

    /**
     * Formats the path for the given entry.
     * <p/>
     * This method formats the timestamp of <code>entry</code> according to the
     * pattern passed in the constructor of this path builder.
     *
     * @param entry  an entry.
     * @param buffer where to write the path to.
     */
    public void formatPath(Entry entry, StringBuffer buffer) {
        buffer.append(timestampFormat.format(new Date(entry.getTimestamp())));
    }
}
