/*
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2020 Adobe
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */

package com.adobe.cq.dam.download.api;

/**
 * High-level exception type for indicating that something went wrong during
 * the process of generating a download. Implementers are encouraged to
 * inherit from this exception to create more specific types of exceptions
 * for indicating when there are issues with the process.
 */
public class DownloadException extends Exception {

    private static final long serialVersionUID = 2658159401073189422L;

    /**
     * Initializes a new exception instance that will have a <code>null</code> message
     * and cause.
     */
    public DownloadException() {
        super();
    }

    /**
     * Initializes a new exception instance that will have a specified message and
     * a <code>null</code> cause.
     * @param message The detail message that can be retrieved with <code>getMessage()</code>
     */
    public DownloadException(String message) {
        super(message);
    }

    /**
     * Initializes a new exception instance that will have a specified message and
     * cause.
     * @param message The detail message that can be retrieved with <code>getMessage()</code>
     * @param cause The underlying cause of the exception, which can be retrieved with <code>getCause()</code>.
     */
    public DownloadException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Initializes a new exception instance that will have a specified message,
     * cause, and configuration.
     * @param message The detail message that can be retrieved with <code>getMessage()</code>
     * @param cause The underlying cause of the exception, which can be retrieved with <code>getCause()</code>.
     * @param enableSuppression Whether or not suppression is enabled or disabled.
     * @param writableStackTrace Whether or not the stack trace should be writable.
     */
    public DownloadException(String message, Throwable cause, boolean enableSuppression,
            boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
    }

}
