/*
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2019 Adobe
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
package com.adobe.cq.inbox.ui.column.provider;

import com.adobe.cq.inbox.ui.InboxItem;
import com.adobe.cq.inbox.ui.column.Column;
import org.osgi.annotation.versioning.ConsumerType;

import javax.annotation.Nonnull;


/**
 * The handler of a column.
 * Responsible for
 *  - providing the definition of a {@link Column}
 *  - providing the value of the column for a given {@link InboxItem}
 */
@ConsumerType
public interface ColumnProvider {
    /**
     * The column handled by this handler
     * @return Column definition
     */
    @Nonnull Column getColumn();

    /**
     * The underlying value of the column for the given Inbox Item.
     *
     * Used for sorting the items by current column.
     *
     * If template path and template name aren't provide in {@link Column} definition,
     * this value is also used to render the cell content of the column (by html encoding the provided 'value')
     *
     * The type of returned value must match the type provided from {@link Column#getType}.
     *
     * @param inboxItem the {@link InboxItem}
     * @return Underlying value of column for inbox item
     */
    default Object getValue(InboxItem inboxItem) {
        return null;
    }
}

