/*
*
*	File: GlyfRaw.java
*
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2004-2005 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
*/

package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;

/** Gives access to a raw 'glyf' table.
 *
 * <p>'glyf' tables do not stand one their own; see 
 * {@link com.adobe.fontengine.font.opentype.Glyf} for a 
 * wrapping which corrects that.</p>
 * 
 * <h4>Version handling</h4>
 * 
 * <p>'glyf' tables are not versionned.</p>
 *
 * <h4>Synchronization</h4>
 * 
 * <p>Like all tables, these objects are immutable.</p> 
 **/

final class GlyfRaw extends Table {
  
  public static final int ARG_1_AND_2_ARE_WORDS      = 0x0001;
  public static final int ARGS_ARE_XY_VALUES_WORDS   = 0x0002;
  public static final int ROUND_XY_TO_GRID           = 0x0004;
  public static final int WE_HAVE_A_SCALE            = 0x0008;
  public static final int MORE_COMPONENTS            = 0x0020;
  public static final int WE_HAVE_AN_X_AND_Y_SCALE   = 0x0040;
  public static final int WE_HAVE_A_TWO_BY_TWO       = 0x0080;
  public static final int WE_HAVE_INSTRUCTIONS       = 0x0100;
  public static final int USE_MY_METRICS             = 0x0200;
  public static final int OVERLAP_COMPOUND           = 0x0400;
  public static final int SCALED_COMPONENT_OFFSET    = 0x0800;
  public static final int UNSCALED_COMPONENT_OFFSET  = 0x1000;
 
  protected GlyfRaw () {
    super();
  }

  protected GlyfRaw (FontByteArray buffer) 
  throws java.io.IOException, InvalidFontException, UnsupportedFontException {
    super (buffer);
  }

  /** Get the bounding box for a glyph.
   * @param start the offset of the outline
   * @param limit the offset of the byte following the outline
   */
  public Rect getGlyphBoundingBox (int start, int limit)
  throws InvalidFontException {
    if (start == limit) {
      return Rect.emptyRect; }
    else {
      return new Rect (this.data.getint16 (start + 2), this.data.getint16 (start + 4),
    		  this.data.getint16 (start + 6), this.data.getint16 (start + 8)); }
  }

    /** Whether a glyph is composite.
     * @param start the offset of the outline
     * @param limit the offset of the byte following the outline
     */
  public boolean isComposite (int start, int limit)
  throws InvalidFontException {
    if (start == limit) {
      return false; }
    else {
      return this.data.getint16 (start) == -1; }
  }
}
