/*
 * File: BengaliFormatter.java
 * 
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is
 *      obtained from Adobe Systems Incorporated.
 *
 */
package com.adobe.fontengine.inlineformatting.infontformatting;

import com.adobe.fontengine.inlineformatting.AttributedRun;

final class BengaliFormatter extends IndicFormatter {

  protected int splitVowelsAndNormalize (AttributedRun run, int start, int limit) {
     while (start < limit) {
      int usv = run.elementAt (start);
      switch (usv) {
        case 0x09CB: {
          run.replace (start, new int[] {0x09C7, 0x09BE});
          limit++; 
          start += 2;
          break; }
        case 0x09CC: {
          run.replace (start, new int[] {0x09C7, 0x09D7});
          limit++; 
          start += 2;
          break; }
        default: {
          start++; 
          break; }}}

    return limit;
  }

  /* @see com.adobe.fontengine.inlineformatting.infontformatting.OTIndicFormatter#nukta()
   */
  protected int nukta () {
    return 0x09BC;
  }

  /* @see com.adobe.fontengine.inlineformatting.infontformatting.OTIndicFormatter#virama()
   */
  protected int virama () {
    return 0x9CD;
  }

  /* @see com.adobe.fontengine.inlineformatting.infontformatting.OTIndicFormatter#ra()
   */
  protected boolean isSatelliteWhenInitial (int usv) {
    return usv == 0x9B0;
  }

  /* @see com.adobe.fontengine.inlineformatting.infontformatting.OTIndicFormatter#isConsonant(int)
   */
  protected boolean isConsonant (int usv) {
    return (   0x995 <= usv && usv <= 0x9B9
            || 0x9DC <= usv && usv <= 0x9E1
            || 0x9F0 <= usv && usv <= 0x9F0
            || 0x25cc == usv);
  }

  /* @see com.adobe.fontengine.inlineformatting.infontformatting.OTIndicFormatter#hasNukta(int)
   */
  protected boolean hasNukta (int usv) {
    return (   0x9DC == usv
            || 0x9DD == usv
            || 0x9DF == usv);
  }

  /* @see com.adobe.fontengine.inlineformatting.infontformatting.OTIndicFormatter#removeNukta(int)
   */
  protected int removeNukta (int usv) {
    switch (usv) {
    case 0x9DC: return 0x9A1;
    case 0x9DD: return 0x9A2;
    case 0x9DF: return 0x9AF;
    default:    return usv; }
  }

  /* @see com.adobe.fontengine.inlineformatting.infontformatting.OTIndicFormatter#isMark(int)
   */
  protected boolean isMark (int usv) {
    return (   0x09BE <= usv && usv <= 0x09CC
            || 0x09E2 <= usv && usv <= 0x9E3 
            || 0x0981 <= usv && usv <= 0x983
            || 0x09D7 <= usv && usv <= 0x9D7);
  }

  /* @see com.adobe.fontengine.inlineformatting.infontformatting.OTIndicFormatter#isIndependentVowel(int)
   */
  protected boolean isIndependentVowel (int usv) {
    return (   0x0985 <= usv && usv <= 0x0994
            || 0x09E2 <= usv && usv <= 0x09E3
            || 0x25cc == usv);
  }

  
  protected Position getPosition (int usv) {
    switch (usv) {
      case 0x9c7:
      case 0x9c8:
      case 0x9Bf: return Position.left;
      
      case 0x981: return Position.topOther;
      
      case 0x9C1:
      case 0x9C2:
      case 0x9C3:
      case 0x9C4:
      case 0x9E2:
      case 0x9E3: return Position.bottom;
          
      case 0x9Be:
      case 0x9C0:
      case 0x949:
      case 0x94a:
      case 0x94b:
      case 0x94c: return Position.rightMatra;
      
      case 0x982:
      case 0x983:
      case 0x9D7: return Position.rightOther;
      
      default:    return Position.any; }
  }
  
  protected Shape rephLike (int usv) {
    if (0x9B0 == usv) {
      return Shape.rephCons; }
    else {
      return Shape.any; }
  }

  protected boolean subjoins (int usv) {
    return usv == 0x9B0 || usv == 0x9F0 || usv == 0x9AC;
  }
  
  protected boolean postjoins (int usv) {
    return usv == 0x9af;
  }
  
  protected boolean postjoinsIndependentVowels (int usv) {
    return usv == 0x9af;
  }
}
