/*
 * File: DecryptedState.java
 *  
 *************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.internal.pdftoolkit.core.securityframework;

import java.io.Serializable;

import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityAuthorizationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;

/**
 * This interface represents the security state of an unlocked document. Clients can get
 * this state from unlocked PDFDocument objects.
 * This state information can be used to decrypt unlocked PDFDocument without need
 * for entering user password or credential information.
 * @author hraghav
 */
public interface DecryptedState extends Serializable
{
	/**
	 * Get encryption key when no crypt filter is used
	 * @return byte[]
	 */
	byte[] getEncryptKey();
	
	/**
	 * Get encryption key corresponding to a cryptfilter
	 * @return byte[]
	 */
	byte[] getEncryptKey(String cryptFilter);

	/**
	 * Set encryption key corresponding to a cryptfilter
	 * @param cryptFilter Crypt filter
	 * @param encryptKey  byte array representing encryption key
	 */
	void setEncryptKey(String cryptFilter, byte[] encryptKey);
	
	/**
	 * Set encryption key when no crypt filter is used
	 * @param encryptKey  byte array representing encryption key
	 */
	void setEncryptKey(byte[] encryptKey);

	/**
	 * Set perms flag
	 * @param mPerms
	 */
	void setPerms(Integer mPerms);

	/**
	 * Get perms flag
	 * @return Integer
	 */ 
	Integer getPerms();

	/**
	 * Get security manager for this decrypted state. 
	 * For new implementations of {@link DecryptedState}, clients need to return
	 * their own {@link SecurityManager} which will ensure that state information
	 * in this class is correctly used while decrypting.
	 * @param cosDocument
	 * @return SecurityManager
	 * @throws PDFSecurityConfigurationException
	 * @throws PDFSecurityAuthorizationException
	 * @throws PDFCosParseException
	 * @throws PDFIOException
	 * @throws PDFSecurityException
	 */
	SecurityManager getSecurityManager(CosDocument cosDocument)
	throws PDFSecurityConfigurationException, PDFSecurityAuthorizationException, PDFCosParseException, PDFIOException, PDFSecurityException;
}