/* ****************************************************************************
*
*	File: SecurityKeyPasswordInterface.java
*
* ****************************************************************************
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2005 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
* ***************************************************************************/

package com.adobe.internal.pdftoolkit.core.securityframework.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityKey;

/**
 * This is a Security Key factory that 
 * can be used to instantiate different varieties of the password-based Security Keys.</P>
 * <P><B>Note</B>: When the abstract methods declared in this class are implemented
 * by the user, they will be contained in the objects that <code>newInstance()</code> methods return. </P>
 * @author itenenbo
 */
public interface SecurityKeyPasswordInterface extends SecurityKey 
{
	/**
	 * <P>Create an object that represents this specified security password 
	 * for this specified PDF document. </P>
	 * @param pdfDoc the PDF document representation for which to set the specified password.
	 * @param password a byte array that holds the password for this document.
	 * @return an object representing the security password for this document.
	 * @throws PDFSecurityException 
	 */
	abstract public SecurityKeyPasswordInterface makeSecurityKey(CosDocument pdfDoc, byte[] password, SecurityProvidersImpl providers) 
    throws PDFSecurityException;
	
	/**
	 * Get the document owner's password.
	 * This method can be called only after establishing the right to decrypt the PDFDocument 
	 * was authenticated (that is, after the PDFDocument has been successfully unlock'ed).
	 * 
	 * @return a byte array with the owner password. The owner password 
	 * is <i><b>Permissions</b></I> in the Acrobat UI.</P>
	 * <P>Return <code>null</code> if the document was unlocked with the user password.
	 * 
	 * @throws PDFParseException
	 * @throws PDFSecurityException 
	 */
	abstract public byte[] getOwnerPassword() 
    throws PDFParseException, PDFSecurityException;
	
	/**
	 * Get the document user's password.
	 * This method can be called only after establishing the right to decrypt the document 
	 * was authenticated (That is, after the PDFDocument has been unlock'ed}.
	 * @return a byte array with the password. Returns the user (<i><b>Open</b></I> in the Acrobat
	 * UI) password regardless whether the document was unlocked with the user or owner password.
	 * @throws PDFParseException
	 * @throws PDFSecurityException 
	 */
	abstract public byte[] getUserPassword() 
    throws PDFParseException, PDFSecurityException;
	
}
