/*
 * File: RNGElementNotSupportedException.java
 * ************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.xmp.schema.rng.parser.exceptions;

/**
 * This exception is thrown on encountering an element in RelaxNG schema, which is not yet supported by the RelaxNG
 * Parser in that context.
 * 
 * @author hraghav
 */
public class RNGElementNotSupportedException extends RNGParseException
{
	private static final long serialVersionUID = 4631275050411273383L;

	/**
	 * 
	 * Constructs a new RNGElementNotSupportedException.
	 * 
	 * @param message
	 *            the detail message.
	 */
	public RNGElementNotSupportedException(String message)
	{
		super(message);
	}
}
