/* ************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2021 Adobe
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any.  The
 * intellectual and technical concepts contained herein are
 * proprietary to Adobe and its suppliers and are protected
 * by all applicable intellectual property laws, including
 * trade secret and copyright laws.  Dissemination of this
 * information or reproduction of this material is strictly
 * forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.day.cq.dam.api.smartcrop;


import java.util.List;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;

import aQute.bnd.annotation.ProviderType;
/**
 * Handles post processing of different crud events for smart crops
 *
 * The implemenations of this interface can relay the appropriate event to
 *  a downstream system such as dynamicmedia.
 */
@ProviderType
public interface SmartCropPostProcessor {

    public static enum EventType {
        ADD,
        EDIT,
        REMOVE;
    }
    
    void process(EventType type, Asset asset, List<SmartCrop> crops);
    
    void process(EventType type, Rendition rendition);
}
