/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2011 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.day.cq.replication;

/**
 * Transport handler that supports polling of modified content that should be
 * reverse replicated.
 */
public interface PollingTransportHandler {

    /**
     * Poll modified content from the transport handler.
     *
     * @param ctx transport context
     * @param tx replication transaction
     * @param factory replication content factory
     * @return modified content
     *
     * @throws ReplicationException if a replication error occurs
     * @throws TransportException if the underlying transport receives an unexpected answer
     */
    ReverseReplication[] poll(TransportContext ctx, ReplicationTransaction tx, ReplicationContentFactory factory)
            throws ReplicationException;

}
