/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.search.eval;

import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.query.Row;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

import com.day.cq.search.Query;

/**
 * <code>EvaluationContext</code> is a helper class that provides access to
 * various elements required for {@link PredicateEvaluator PredicateEvaluators}
 * during the query evaluation process.
 * 
 * @since 5.2
 */
public interface EvaluationContext {

    /**
     * Retrieves a {@link PredicateEvaluator} for the given type.
     */
    PredicateEvaluator getPredicateEvaluator(String type);
    
    /**
     * Returns the session under which the {@link Query} runs.
     */
    Session getSession();
    
    /**
     * Returns a (jcr) resource resolver based on the current session.
     */
    ResourceResolver getResourceResolver();
    
    /**
     * Helper method for implementations that returns the {@link Node} behind
     * a {@link Row}. This method will be obsolete with JCR 2.0, where the
     * new <code>Row.getNode()</code> method will be available.
     * 
     * @see #getPath(Row)
     * @see #getResource(Row)
     */
    Node getNode(Row row);

    /**
     * Helper method for returning the path behind a row. If an error occurs,
     * <code>null</code> will be returned.
     * 
     * @see #getNode(Row)
     * @see #getResource(Row)
     */
    String getPath(Row row);
    
    /**
     * Helper method that returns the resource for the given row.
     * 
     * @see #getPath(Row)
     * @see #getNode(Row)
     */
    Resource getResource(Row row);

    /**
     * Allows to store any object temporarily for the current evaluation. This
     * is useful as the predicate evaluators can be used by multiple executions
     * (in different threads) at the same time and thus need a safe storage -
     * object fields are not usable.
     * 
     * @see #get(String)
     * 
     * @param key
     *            unique key for the value
     * @param value
     *            any object or <code>null</code> to remove the entry under key
     * 
     * @since 5.3
     */
    void put(String key, Object value);

    /**
     * Retrieves an object that is temporarily stored during the current
     * evaluation.
     * 
     * @see #put(String, Object)
     * 
     * @param key
     *            unique key for the value
     * @return the value object or <code>null</code> if there is no value stored
     *         under the given key
     * 
     * @since 5.3
     */
    Object get(String key);
}
