/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.sites.ui.models.admin.security.permission;

import com.adobe.granite.security.user.util.AuthorizableUtil;
import com.day.cq.security.util.CqActions;
import java.io.StringWriter;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;

@Model(adaptables={SlingHttpServletRequest.class})
public final class Permissions {
    @Self
    private SlingHttpServletRequest slingRequest;
    @ValueMapValue
    private String principalName;
    @ValueMapValue
    private String avatar;
    @Inject
    @SlingObject
    private Resource resource;
    @Inject
    private ResourceResolver resolver;
    private String label;
    private String path;
    private boolean aclEdit;
    private boolean read;
    private boolean modify;
    private boolean delete;
    private boolean replicate;
    private boolean create;
    private CqActions cqActions;

    @PostConstruct
    protected void initModel() throws RepositoryException {
        String resourcePath;
        Session session = this.resolver.adaptTo(Session.class);
        PrincipalManager principalManager = ((JackrabbitSession)session).getPrincipalManager();
        AccessControlManager accessControlManager = session.getAccessControlManager();
        UserManager userManager = ((JackrabbitSession)session).getUserManager();
        this.path = this.resource.getPath();
        if (StringUtils.isEmpty(this.principalName)) {
            return;
        }
        Principal principal = principalManager.getPrincipal(this.principalName);
        Authorizable authorizable = userManager.getAuthorizable(principal);
        if (authorizable != null) {
            this.label = AuthorizableUtil.getFormattedName(this.resolver, authorizable.getID());
            if (StringUtils.isEmpty(this.label)) {
                this.label = this.principalName;
            }
        } else {
            this.label = this.principalName;
        }
        if ((resourcePath = this.slingRequest.getParameter("item")) == null) {
            resourcePath = this.slingRequest.getRequestPathInfo().getSuffix();
        }
        if (StringUtils.isNotEmpty(resourcePath) && ((JackrabbitSession)session).hasPermission(resourcePath, "read_access_control")) {
            this.cqActions = new CqActions(session);
            Collection<String> allowedActions = this.getActions(accessControlManager, resourcePath, this.principalName, this.cqActions);
            if (allowedActions != null) {
                this.read = allowedActions.contains("read");
                this.modify = allowedActions.contains("modify");
                this.delete = allowedActions.contains("delete");
                this.replicate = allowedActions.contains("replicate");
                this.create = allowedActions.contains("create");
            }
            Collection<String> principalAllowedActions = this.cqActions.getAllowedActions(resourcePath, null);
            this.aclEdit = principalAllowedActions.contains("acl_edit");
        }
    }

    private Collection<String> getActions(AccessControlManager accessControlManager, String resourcePath, String principalName, CqActions cqActions) throws RepositoryException {
        AccessControlPolicy[] locals;
        for (AccessControlPolicy policy : locals = accessControlManager.getPolicies(resourcePath)) {
            if (!(policy instanceof AccessControlList)) continue;
            for (AccessControlEntry ace : ((AccessControlList)policy).getAccessControlEntries()) {
                if (!(ace instanceof JackrabbitAccessControlEntry) || ace.getPrincipal() == null || !principalName.equals(ace.getPrincipal().getName())) continue;
                return cqActions.getAllowedActions(resourcePath, Collections.singleton(ace.getPrincipal()));
            }
        }
        return null;
    }

    public String getAclData() throws JSONException {
        StringWriter sw = new StringWriter();
        JSONWriter jw = new JSONWriter(sw);
        jw.object();
        jw.key("principalName").value(this.principalName);
        jw.key("label").value(this.label);
        jw.key("avatar").value(this.avatar);
        jw.key("read").value(this.read);
        jw.key("modify").value(this.modify);
        jw.key("delete").value(this.delete);
        jw.key("replicate").value(this.replicate);
        jw.key("create").value(this.create);
        jw.endObject();
        return sw.toString();
    }

    public String getPath() {
        return this.path;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean canEditAcl() {
        return this.aclEdit;
    }

    public boolean canRead() {
        return this.read;
    }

    public boolean canModify() {
        return this.modify;
    }

    public boolean canDelete() {
        return this.delete;
    }

    public boolean canReplicate() {
        return this.replicate;
    }

    public boolean canCreate() {
        return this.create;
    }
}

