/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.Table;
import java.io.IOException;

final class GlyfRaw
extends Table {
    public static final int ARG_1_AND_2_ARE_WORDS = 1;
    public static final int ARGS_ARE_XY_VALUES_WORDS = 2;
    public static final int ROUND_XY_TO_GRID = 4;
    public static final int WE_HAVE_A_SCALE = 8;
    public static final int MORE_COMPONENTS = 32;
    public static final int WE_HAVE_AN_X_AND_Y_SCALE = 64;
    public static final int WE_HAVE_A_TWO_BY_TWO = 128;
    public static final int WE_HAVE_INSTRUCTIONS = 256;
    public static final int USE_MY_METRICS = 512;
    public static final int OVERLAP_COMPOUND = 1024;
    public static final int SCALED_COMPONENT_OFFSET = 2048;
    public static final int UNSCALED_COMPONENT_OFFSET = 4096;

    protected GlyfRaw() {
    }

    protected GlyfRaw(FontByteArray buffer) throws IOException, InvalidFontException, UnsupportedFontException {
        super(buffer);
    }

    public Rect getGlyphBoundingBox(int start, int limit) throws InvalidFontException {
        if (start == limit) {
            return Rect.emptyRect;
        }
        return new Rect(this.data.getint16(start + 2), this.data.getint16(start + 4), this.data.getint16(start + 6), this.data.getint16(start + 8));
    }

    public boolean isComposite(int start, int limit) throws InvalidFontException {
        if (start == limit) {
            return false;
        }
        return this.data.getint16(start) == -1;
    }
}

