/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.inlineformatting.infontformatting;

import com.adobe.fontengine.inlineformatting.AttributedRun;
import com.adobe.fontengine.inlineformatting.infontformatting.IndicFormatter;

public class TeluguFormatter
extends IndicFormatter {
    @Override
    protected int splitVowelsAndNormalize(AttributedRun run, int start, int limit) {
        block3: while (start < limit) {
            int usv = run.elementAt(start);
            switch (usv) {
                case 3144: {
                    run.replace(start, new int[]{3142, 3158});
                    ++limit;
                    start += 2;
                    continue block3;
                }
            }
            ++start;
        }
        return limit;
    }

    @Override
    protected int nukta() {
        return -1;
    }

    @Override
    protected int virama() {
        return 3149;
    }

    @Override
    protected boolean isConsonant(int usv) {
        return 3093 <= usv && usv <= 3129 || 9676 == usv;
    }

    @Override
    protected boolean hasNukta(int usv) {
        return false;
    }

    @Override
    protected int removeNukta(int usv) {
        return usv;
    }

    @Override
    protected boolean isMark(int usv) {
        return 3073 <= usv && usv <= 3075 || 3134 <= usv && usv <= 3158;
    }

    @Override
    protected boolean isIndependentVowel(int usv) {
        return 3077 <= usv && usv <= 3092 || 9676 == usv;
    }

    @Override
    protected IndicFormatter.Position getPosition(int usv) {
        switch (usv) {
            case 3134: 
            case 3135: 
            case 3136: 
            case 3142: 
            case 3143: 
            case 3146: 
            case 3147: 
            case 3148: {
                return IndicFormatter.Position.topMatra;
            }
            case 3158: {
                return IndicFormatter.Position.bottom;
            }
            case 3137: 
            case 3138: 
            case 3139: 
            case 3140: {
                return IndicFormatter.Position.rightMatra;
            }
            case 3073: 
            case 3074: 
            case 3075: {
                return IndicFormatter.Position.rightOther;
            }
        }
        return IndicFormatter.Position.any;
    }

    @Override
    protected IndicFormatter.Shape rephLike(int usv) {
        return IndicFormatter.Shape.any;
    }

    @Override
    protected boolean subjoins(int usv) {
        return this.isConsonant(usv);
    }

    @Override
    protected boolean postjoins(int usv) {
        return false;
    }

    @Override
    protected boolean postjoinsIndependentVowels(int usv) {
        return false;
    }
}

