/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.cos;

import com.adobe.internal.io.stream.InputByteStream;
import java.io.IOException;
import java.io.InputStream;

final class CosParseBuf
implements InputByteStream {
    private InputByteStream mBaseBuf = null;
    private int mBufferSize = 0;
    private long mOrigPos = 0L;
    private int mBaseOffset = 0;
    private int mPos = 0;
    private int mEnd = 0;
    private byte[] mBuffer = null;
    private boolean readTillBufferSize = false;

    CosParseBuf(InputByteStream baseBuf, int bufferSize) throws IOException {
        this.mBaseBuf = baseBuf;
        this.mBufferSize = bufferSize;
        this.mBuffer = new byte[this.mBufferSize];
        this.mOrigPos = baseBuf.getPosition();
        this.mEnd = baseBuf.read(this.mBuffer);
    }

    CosParseBuf(InputByteStream baseBuf, int bufferSize, boolean readTillBufferSize) throws IOException {
        this(baseBuf, bufferSize);
        this.readTillBufferSize = readTillBufferSize;
    }

    @Override
    public int read() throws IOException {
        if (this.readTillBufferSize && this.mPos == this.mBufferSize) {
            return -1;
        }
        if (this.mPos == this.mEnd) {
            this.mBaseOffset += this.mPos;
            this.mEnd = this.mBaseBuf.read(this.mBuffer);
            if (this.mEnd <= 0) {
                return -1;
            }
            this.mPos = 0;
        }
        return 0xFF & this.mBuffer[this.mPos++];
    }

    @Override
    public int unget() {
        if (this.mPos > 0) {
            --this.mPos;
        }
        return this.mBuffer[this.mPos];
    }

    @Override
    public long getPosition() {
        return this.mOrigPos + (long)this.mBaseOffset + (long)this.mPos;
    }

    @Override
    public void close() throws IOException {
        this.mBaseBuf.seek(this.mOrigPos + (long)this.mBaseOffset + (long)this.mPos);
        this.mBaseBuf = null;
        this.mBuffer = null;
    }

    @Override
    public boolean eof() throws IOException {
        if (this.mPos < this.mEnd) {
            return false;
        }
        return this.mBaseBuf.eof();
    }

    @Override
    public long bytesAvailable() throws IOException {
        throw new IOException("Unimplemented method call on CosParseBuf: bytesAvailable");
    }

    public boolean exists(byte[] key, long extent) throws IOException {
        throw new IOException("Unimplemented method call on CosParseBuf: exists");
    }

    public long indexOf(byte[] key) throws IOException {
        throw new IOException("Unimplemented method call on CosParseBuf: indexOf");
    }

    @Override
    public long length() throws IOException {
        throw new IOException("Unimplemented method call on CosParseBuf: length");
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        throw new IOException("Unimplemented method call on CosParseBuf: read");
    }

    @Override
    public int read(byte[] bytes, int position, int length) throws IOException {
        throw new IOException("Unimplemented method call on CosParseBuf: read");
    }

    @Override
    public InputByteStream seek(long position) throws IOException {
        throw new IOException("Unimplemented method call on CosParseBuf: seek");
    }

    @Override
    public InputByteStream slice() throws IOException {
        throw new IOException("Unimplemented method call on CosParseBuf: slice");
    }

    @Override
    public InputByteStream slice(long begin, long length) throws IOException {
        throw new IOException("Unimplemented method call on CosParseBuf: slice");
    }

    @Override
    public InputStream toInputStream() throws IOException {
        throw new IOException("Unimplemented method call on CosParseBuf: toInputStream");
    }
}

