/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.cos;

import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.IO;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosBoolean;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosEncryption;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosNull;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectInfo;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectStream;
import com.adobe.internal.pdftoolkit.core.cos.CosRepairUtils;
import com.adobe.internal.pdftoolkit.core.cos.CosUtils;
import com.adobe.internal.pdftoolkit.core.cos.DecryptingInputStream;
import com.adobe.internal.pdftoolkit.core.cos.EncryptingOutputStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.filter.CustomFilterRegistry;
import com.adobe.internal.pdftoolkit.core.filter.FilterParams;
import com.adobe.internal.pdftoolkit.core.filter.FilterStream;
import com.adobe.internal.pdftoolkit.core.securityframework.EncryptionHandlerState;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.util.BooleanHolder;
import com.adobe.internal.pdftoolkit.core.util.StringOps;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipException;

public class CosStream
extends CosDictionary {
    private boolean mDataInPDF;
    private long mPos;
    private InputByteStream mDataStream;
    private boolean mDataEncoded;
    private boolean mToEncrypt;
    private boolean mIsEncrypted;
    private CosArray mOutputFilters;
    private ASName mCryptFilter;
    private boolean mCryptFilterSet;

    CosStream(CosDocument doc, Map map, CosObjectInfo info, long pos) throws PDFCosParseException, PDFIOException, IOException, PDFSecurityException {
        super(doc, map, info);
        this.init(true, pos, null, true, true);
    }

    CosStream(CosDocument doc, CosObjectInfo info) throws PDFCosParseException, IOException, PDFIOException, PDFSecurityException {
        super(doc, new LinkedHashMap<ASName, CosObject>(), info);
        this.init(false, 0L, null, true, true);
    }

    CosStream(CosDocument doc, CosObjectInfo info, InputByteStream rep) throws PDFCosParseException, IOException, PDFIOException, PDFSecurityException {
        super(doc, new LinkedHashMap<ASName, CosObject>(), info);
        this.init(false, 0L, rep, true, true);
    }

    private void init(boolean dataInPDF, long pos, InputByteStream decoded, boolean toEncrypt, boolean isEncrypted) throws PDFCosParseException, IOException, PDFIOException, PDFSecurityException {
        this.mDataInPDF = dataInPDF;
        this.mPos = pos;
        if (!dataInPDF) {
            this.setCachedStream(false, decoded);
            this.put(ASName.k_Length, 0);
        } else {
            CosObject lenObj = this.get(ASName.k_Length);
            if (!(lenObj instanceof CosNumeric)) {
                long length = CosRepairUtils.getStreamLength(this.getDocument(), pos);
                if (length == -1L) {
                    throw new PDFCosParseException("Expected 'endstream' for stream at pos " + pos);
                }
                this.setRepairedValue(ASName.k_Length, this.getDocument().createCosNumeric(length));
            }
        }
        this.mToEncrypt = toEncrypt;
        this.mIsEncrypted = isEncrypted;
    }

    @Override
    void close() throws IOException {
        this.releaseStreams();
        this.mOutputFilters = null;
        super.close();
    }

    @Override
    void release() throws IOException {
        this.releaseStreams();
        this.mDataInPDF = true;
        this.mIsEncrypted = this.mToEncrypt;
        super.release();
    }

    private void releaseStreams() throws IOException {
        this.setCachedStream(false, null);
    }

    private InputByteStream getCachedStream(boolean encoded) {
        if (encoded != this.mDataEncoded) {
            return null;
        }
        return this.mDataStream;
    }

    private void setCachedStream(boolean encoded, InputByteStream newStream) throws IOException {
        if (this.mDataStream != null) {
            this.mDataStream.close();
        }
        this.mDataStream = newStream;
        this.mDataEncoded = encoded;
    }

    @Override
    public CosObject put(ASName key, CosObject cosObject) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            CosObject oldValue;
            if (!(!this.mDataInPDF && !this.mDataEncoded || key != ASName.k_Filter && key != ASName.k_DecodeParms || cosObject.equals(oldValue = this.get(key)))) {
                InputByteStream stm = this.getStream(false, false, true);
                this.mCryptFilterSet = false;
                this.setCachedStream(false, stm);
                this.mDataInPDF = false;
            }
            return super.put(key, cosObject);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    @Override
    public CosObject remove(ASName key) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            CosObject oldValue;
            if ((this.mDataInPDF || this.mDataEncoded) && (key == ASName.k_Filter || key == ASName.k_DecodeParms) && (oldValue = this.get(key)) != null) {
                InputByteStream stm = this.getStream(false, false, true);
                this.mCryptFilterSet = false;
                this.setCachedStream(false, stm);
                this.mDataInPDF = false;
            }
            return super.remove(key);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    @Override
    public int getType() {
        return 7;
    }

    public long getLength() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return this.getLong(ASName.k_Length);
    }

    public InputByteStream getStreamDecoded() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            return this.getStream(false, true, true);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getStreamDecodedNoCopying() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        InputByteStream ibs = null;
        OutputByteStream os = null;
        try {
            try {
                BooleanHolder wasDecrypted = new BooleanHolder(false);
                InputStream is = this.getStreamForCopying(false, wasDecrypted);
                if (wasDecrypted.getValue()) {
                    os = this.getStreamManager().getUnregisteredOutputByteStream(ByteWriterFactory.Fixed.GROWABLE, is.available());
                    this.copyStream(os, is, false);
                    os.flush();
                    ibs = os.closeAndConvert();
                    os = null;
                    InputStream inputStream2 = ibs.toInputStream();
                    return inputStream2;
                }
                InputStream inputStream = is;
                return inputStream;
            }
            finally {
                if (os != null) {
                    os.close();
                }
                if (ibs != null) {
                    ibs.close();
                }
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public InputByteStream getStreamEncoded() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            return this.getStream(true, true, true);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public <T> boolean copyStream(T destStm, boolean encoded) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            return this.copyStream(destStm, this.getStreamForCopying(encoded, new BooleanHolder(false)), encoded);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    private <T> boolean copyStream(T destStm, InputStream srcStm, boolean encoded) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        InputStream is = null;
        try {
            InputStream inputStream = is = srcStm != null ? srcStm : this.getStreamForCopying(encoded, new BooleanHolder(false));
            if (is != null) {
                long bytesCopied;
                block19: {
                    bytesCopied = 0L;
                    try {
                        if (destStm instanceof OutputStream) {
                            bytesCopied = IO.copy(is, (OutputStream)destStm);
                            break block19;
                        }
                        if (destStm instanceof OutputByteStream) {
                            bytesCopied = IO.copy(is, (OutputByteStream)destStm);
                            break block19;
                        }
                        throw new PDFIOException("Destination stream must be either OutputStream or OutputByteStream.");
                    }
                    catch (EOFException e) {
                        bytesCopied = 1L;
                    }
                    catch (ZipException e) {
                        throw new PDFCosParseException(e);
                    }
                }
                boolean bl = bytesCopied != 0L;
                return bl;
            }
            boolean bytesCopied = false;
            return bytesCopied;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
    }

    private InputStream getStreamForCopying(boolean encoded, BooleanHolder wasDecrypted) throws PDFCosParseException, IOException, PDFIOException, PDFSecurityException {
        InputStream is = null;
        InputByteStream ibs = this.getCachedStream(encoded);
        if (ibs == null) {
            if (this.mDataInPDF) {
                EncryptionHandlerState encryptHandle;
                ibs = this.getStreamDataFromPDF();
                is = ibs.toInputStream();
                boolean hasAcroBug = false;
                if (this.needsDecryption(ibs) && !(hasAcroBug = this.checkForAcroBug())) {
                    encryptHandle = this.getDocument().getEncryption().getStreamDecryptionStateHandler(this, ibs);
                    is = new DecryptingInputStream(this, is, encryptHandle);
                    wasDecrypted.setValue(true);
                }
                if (this.needsDecoding(encoded)) {
                    is = this.buildInputFilterStream(is);
                    if (hasAcroBug) {
                        encryptHandle = this.getDocument().getEncryption().getStreamDecryptionStateHandler(this, ibs);
                        is = new DecryptingInputStream(this, is, encryptHandle);
                        wasDecrypted.setValue(true);
                    }
                }
            } else if (!encoded && (ibs = this.getCachedStream(true)) != null) {
                is = this.buildInputFilterStream(ibs.toInputStream());
            }
        }
        if (is != null) {
            return is;
        }
        if (ibs != null) {
            return ibs.toInputStream();
        }
        return null;
    }

    InputByteStream getStream(boolean encoded, boolean slice, boolean register) throws PDFCosParseException, IOException, PDFIOException, PDFSecurityException {
        InputByteStream ibs = this.getCachedStream(encoded);
        if (ibs == null) {
            if (this.mDataInPDF && (this.needsDecryption(ibs = this.getStreamDataFromPDF()) || this.needsDecoding(encoded))) {
                ibs.close();
                ibs = null;
            }
            if (ibs == null) {
                OutputByteStream obs = register ? this.getStreamManager().getOutputByteStreamDecryptedDocument(ByteWriterFactory.Fixed.GROWABLE, this.getLong(ASName.k_Length)) : this.getStreamManager().getUnregisteredOutputByteStream(ByteWriterFactory.Fixed.GROWABLE, this.getInt(ASName.k_Length));
                this.copyStream(obs, encoded);
                ibs = obs.closeAndConvert();
            } else if (slice) {
                ibs = ibs.slice();
            }
        } else if (slice) {
            ibs = ibs.slice();
        }
        return ibs;
    }

    private InputByteStream getStreamDataFromPDF() throws PDFIOException, PDFCosParseException, PDFSecurityException {
        CosDocument doc = this.getDocument();
        Long length = this.getLong(ASName.k_Length);
        InputByteStream ibs = null;
        if (length == null) {
            if (doc.getUseRepairList()) {
                return this.setRepairedStreamLength(doc, this.mPos);
            }
            throw new PDFCosParseException("CosStream with object number -  " + this.getObjNum() + " does not have a length entry.");
        }
        try {
            boolean isStreamLengthOk;
            ibs = doc.getStream(this.mPos, length);
            if (doc.getUseRepairList() && !(isStreamLengthOk = CosRepairUtils.isStreamEndValid(doc, this.mPos + length))) {
                ibs = this.setRepairedStreamLength(doc, this.mPos);
            }
        }
        catch (PDFIOException e) {
            if (doc.getUseRepairList()) {
                ibs = this.setRepairedStreamLength(doc, this.mPos);
            }
            throw new PDFCosParseException(e);
        }
        return ibs;
    }

    private InputByteStream setRepairedStreamLength(CosDocument doc, long currentPos) throws PDFIOException {
        long actuallength = CosRepairUtils.getStreamLength(this.getDocument(), this.mPos);
        InputByteStream ibs = this.getDocument().getStream(this.mPos, actuallength);
        this.setRepairedValue(ASName.k_Length, this.getDocument().createCosNumeric(actuallength));
        return ibs;
    }

    protected void adjustPos(long offset) {
        this.mPos += offset;
    }

    ASName getCryptFilter() throws PDFCosParseException, IOException, PDFIOException, PDFSecurityException {
        if (this.mCryptFilterSet) {
            return this.mCryptFilter;
        }
        ASName filterName = null;
        CosObject filter = this.get(ASName.k_Filter);
        if (filter != null) {
            int cryptInd;
            if (filter.getType() == 3) {
                if (((CosName)filter).nameValue().equals(ASName.k_Crypt)) {
                    CosDictionary params = this.getCosDictionary(ASName.k_DecodeParms);
                    filterName = params != null ? params.getName(ASName.k_Name) : ASName.k_Identity;
                }
            } else if (filter.getType() == 5 && (cryptInd = ((CosArray)filter).findName(ASName.k_Crypt)) >= 0) {
                CosArray params = this.getCosArray(ASName.k_DecodeParms);
                if (params != null) {
                    filterName = params.getCosDictionary(cryptInd).getName(ASName.k_Name);
                    if (filterName == null) {
                        filterName = ASName.k_Identity;
                    }
                } else {
                    filterName = ASName.k_Identity;
                }
            }
        }
        this.mCryptFilterSet = true;
        this.mCryptFilter = filterName;
        return filterName;
    }

    private boolean checkForAcroBug() throws PDFCosParseException, IOException, PDFIOException, PDFSecurityException {
        CosObject filter = this.get(ASName.k_Filter);
        return filter instanceof CosArray && ((CosArray)filter).findName(ASName.k_Crypt) > 0;
    }

    private ASName getCryptFilter(CosArray filterList) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        ASName filterName = null;
        if (filterList != null) {
            Iterator<CosObject> filterIter = filterList.iterator();
            while (filterIter.hasNext()) {
                CosArray filterItem = (CosArray)filterIter.next();
                if (((CosName)filterItem.get(0)).nameValue() != ASName.k_Crypt) continue;
                CosObject params = filterItem.get(1);
                filterName = params instanceof CosDictionary ? ((CosDictionary)params).getName(ASName.k_Name) : ASName.k_Identity;
                break;
            }
            this.mCryptFilterSet = true;
            this.mCryptFilter = filterName;
        }
        return filterName;
    }

    private boolean needsDecoding(boolean encoded) throws PDFCosParseException, IOException, PDFIOException, PDFSecurityException {
        if (encoded) {
            return false;
        }
        CosObject filter = this.get(ASName.k_Filter);
        if (filter instanceof CosArray) {
            if (((CosArray)filter).isEmpty()) {
                return false;
            }
            if (((CosArray)filter).size() > 1) {
                return true;
            }
            filter = ((CosArray)filter).get(0);
        }
        return filter instanceof CosName && ((CosName)filter).nameValue() != ASName.k_Crypt;
    }

    private boolean needsEncoding() throws PDFCosParseException, IOException, PDFIOException, PDFSecurityException {
        if (this.mOutputFilters == null) {
            return this.needsDecoding(false);
        }
        if (this.mOutputFilters.isEmpty()) {
            return false;
        }
        return this.mOutputFilters.size() != 1 || ((CosName)((CosArray)this.mOutputFilters.get(0)).get(0)).nameValue() != ASName.k_Crypt;
    }

    public void newDataDecoded(InputByteStream byteStream) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        this.newData(byteStream, false);
    }

    public void newDataEncoded(InputByteStream byteStream) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        this.newData(byteStream, true);
    }

    private void newData(InputByteStream byteStream, boolean encoded) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            this.mDataInPDF = false;
            this.getInfo().markDirty();
            this.setCachedStream(encoded, byteStream);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    void setToEncrypt(boolean encrypted) throws PDFCosParseException, PDFIOException, IOException, PDFSecurityException {
        if (this.mToEncrypt == encrypted) {
            return;
        }
        this.getInfo().markDirty();
        this.mToEncrypt = encrypted;
    }

    void setIsEncrypted(boolean encrypted) throws PDFCosParseException, PDFIOException, IOException, PDFSecurityException {
        if (this.mIsEncrypted == encrypted) {
            return;
        }
        this.getInfo().markDirty();
        this.mIsEncrypted = encrypted;
    }

    public void setOutputFiltersList(CosArray filters) throws PDFCosParseException, PDFIOException, IOException, PDFSecurityException {
        this.mOutputFilters = filters;
        this.getInfo().markDirty();
    }

    public CosArray getOutputFiltersList() {
        return this.mOutputFilters;
    }

    public CosArray getInputFiltersList() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            return this.getInputFilters(false);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    CosArray getInputFilters(boolean removeCryptFilter) throws PDFCosParseException, IOException, PDFIOException, PDFSecurityException {
        CosArray filterList = this.getDocument().createCosArray();
        CosArray filter = null;
        CosObject filterObj = this.get(ASName.k_Filter);
        CosObject paramsObj = this.get(ASName.k_DecodeParms);
        if (filterObj instanceof CosName && (!removeCryptFilter || ((CosName)filterObj).nameValue() != ASName.k_Crypt)) {
            filter = this.getDocument().createCosArray();
            filter.add(filterObj);
            filter.add(paramsObj != null ? paramsObj : this.getDocument().createCosNull());
            filterList.add(filter);
        } else if (filterObj instanceof CosArray) {
            CosObject filterName = null;
            CosObject filterParams = null;
            for (int i = 0; i < ((CosArray)filterObj).size(); ++i) {
                filter = this.getDocument().createCosArray();
                filterName = ((CosArray)filterObj).get(i);
                if (removeCryptFilter && filterName instanceof CosName && ((CosName)filterName).nameValue() == ASName.k_Crypt) continue;
                if (paramsObj != null) {
                    filterParams = ((CosArray)paramsObj).get(i);
                }
                filter.add(filterName);
                filter.add(filterParams != null ? filterParams : this.getDocument().createCosNull());
                filterList.add(filter);
            }
        }
        return filterList;
    }

    private boolean filtersChanged(CosArray filterList, boolean ignoreCrypt) throws PDFCosParseException, PDFIOException, IOException, PDFSecurityException {
        CosObject oldFilterList = this.get(ASName.k_Filter);
        CosObject oldParamsList = this.get(ASName.k_DecodeParms);
        ASName oldFilter = null;
        ASName newFilter = null;
        int oldIndex = 0;
        int newIndex = 0;
        while (true) {
            oldFilter = this.getFilter(oldFilterList, oldIndex);
            if (ignoreCrypt && oldFilter == ASName.k_Crypt) {
                oldFilter = this.getFilter(oldFilterList, ++oldIndex);
            }
            newFilter = this.getFilter(filterList, newIndex);
            if (ignoreCrypt && newFilter == ASName.k_Crypt) {
                newFilter = this.getFilter(filterList, ++newIndex);
            }
            if (oldFilter == null && newFilter == null) {
                return false;
            }
            if (oldFilter != newFilter) {
                return true;
            }
            if (!this.getParams(oldParamsList, oldIndex).equals(this.getParams(filterList, newIndex))) {
                return true;
            }
            ++oldIndex;
            ++newIndex;
        }
    }

    private ASName getFilter(CosObject filterObject, int index) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (filterObject instanceof CosName) {
            if (index != 0) {
                return null;
            }
            return ((CosName)filterObject).nameValue();
        }
        if (filterObject instanceof CosArray) {
            if (index >= ((CosArray)filterObject).size()) {
                return null;
            }
            CosObject objectAtIndex = ((CosArray)filterObject).get(index);
            if (objectAtIndex instanceof CosName) {
                return ((CosName)objectAtIndex).nameValue();
            }
            if (objectAtIndex instanceof CosArray) {
                return ((CosName)((CosArray)objectAtIndex).get(0)).nameValue();
            }
        }
        return null;
    }

    private CosObject getParams(Object paramsObject, int index) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (paramsObject instanceof CosDictionary) {
            if (index != 0) {
                paramsObject = null;
            }
        } else if (paramsObject instanceof CosArray) {
            paramsObject = index >= ((CosArray)paramsObject).size() ? null : ((CosArray)paramsObject).get(index);
        }
        if (!(paramsObject instanceof CosDictionary)) {
            return this.getDocument().createCosNull();
        }
        return (CosDictionary)paramsObject;
    }

    boolean needsEncryption() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return this.needsDecryptionOrEncryption(null, true);
    }

    boolean needsDecryption(InputByteStream stream) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return this.needsDecryptionOrEncryption(stream, false);
    }

    private boolean needsDecryptionOrEncryption(InputByteStream stream, boolean encrypting) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            ASName type;
            boolean needsIt;
            CosEncryption encryptionHandler = this.getDocument().getEncryption();
            boolean encrypted = encrypting ? this.mToEncrypt : this.mIsEncrypted;
            boolean bl = needsIt = encrypting ? encryptionHandler.needsEncryption() : encryptionHandler.needsDecryption();
            if (!encrypted || stream != null && stream.length() == 0L) {
                return false;
            }
            CosObject cosType = this.get(ASName.k_Type);
            ASName aSName = type = cosType instanceof CosName ? ((CosName)cosType).nameValue() : null;
            if (!encryptionHandler.getEncryptionState() || !needsIt || ASName.k_XRef.equals(type)) {
                return false;
            }
            int shouldDoIt = this.getDocument().getEncryption().shouldDecryptOrEncrypt(type, this.getCryptFilter(), encrypting);
            if (shouldDoIt != 0) {
                return shouldDoIt > 0;
            }
            if (this.isDirty() || this instanceof CosObjectStream) {
                return true;
            }
            return this.getCryptFilter() == null && this.getDocument().getLinearization() != null;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    private InputStream buildInputFilterStream(InputStream inputStream) throws PDFCosParseException, IOException, PDFIOException, PDFSecurityException {
        Iterator<CosObject> filterIter;
        CosObject rawFilter = this.get(ASName.k_Filter);
        FilterParams params = FilterStream.buildFilterParams(this.get(ASName.k_DecodeParms));
        if (rawFilter instanceof CosName) {
            ArrayList<CosObject> filterList = new ArrayList<CosObject>();
            filterList.add(rawFilter);
            filterIter = filterList.iterator();
        } else {
            filterIter = rawFilter == null ? this.getDocument().createCosArray().iterator() : ((CosArray)rawFilter).iterator();
        }
        while (filterIter.hasNext()) {
            ASName curFilter = ((CosName)filterIter.next()).nameValue();
            if (curFilter == ASName.k_Crypt) continue;
            inputStream = FilterStream.applyFilter(inputStream, curFilter, params, this.getCustomFilterRegistry());
        }
        return inputStream;
    }

    private void checkOutputFilters() throws PDFCosParseException, PDFIOException, IOException, PDFSecurityException {
        CosArray filterList = this.mOutputFilters;
        if (this.mOutputFilters == null) {
            filterList = this.getInputFiltersList();
        }
        for (int i = 0; i < filterList.size(); ++i) {
            CosDictionary paramsDict;
            CosObject cosCols;
            CosArray filterAtIndex = (CosArray)filterList.get(i);
            if (!(filterAtIndex.get(0) instanceof CosName) || ((CosName)filterAtIndex.get(0)).nameValue() != ASName.k_CCITTFaxDecode) continue;
            int cols = 1728;
            if (filterAtIndex.get(1) instanceof CosDictionary && (cosCols = (paramsDict = (CosDictionary)filterAtIndex.get(1)).get(ASName.k_Columns)) instanceof CosNumeric) {
                int mode;
                cols = cosCols.intValue();
                CosObject cosMode = paramsDict.get(ASName.k_K);
                CosObject cosRows = paramsDict.get(ASName.k_Rows);
                if (cosMode instanceof CosNumeric && (mode = cosMode.intValue()) == -1 && paramsDict.size() == (cosRows == null ? 2 : 3)) {
                    return;
                }
            }
            CosDictionary newParams = this.getDocument().createDirectCosDictionary();
            newParams.put(ASName.k_Columns, cols);
            newParams.put(ASName.k_K, -1);
            filterAtIndex.add(1, newParams != null ? newParams : this.getDocument().createCosNull());
            this.setOutputFiltersList(filterList);
            return;
        }
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    public long getStreamDataOffset() {
        long objPos = this.getObjPos();
        if (objPos == 0L || this.mPos == 0L) {
            return -1L;
        }
        return this.mPos - objPos;
    }

    @Override
    void writeOut(OutputByteStream dstByteStm, boolean inString, boolean inDebugMode) throws PDFCosParseException, PDFIOException, IOException, PDFSecurityException {
        this.writeOut(dstByteStm, inString, inDebugMode, false);
    }

    private void setFlateOuputFilter() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        ASName type;
        CosObject cosType = this.get(ASName.k_Type);
        ASName aSName = type = cosType instanceof CosName ? ((CosName)cosType).nameValue() : null;
        if (type != ASName.k_Metadata) {
            this.put(ASName.k_Filter, this.getDocument().createCosName(ASName.k_FlateDecode));
            this.remove(ASName.k_DecodeParms);
        }
    }

    private boolean isFlateFilterObject(CosObject filterObj) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (filterObj instanceof CosName && filterObj.nameValue() == ASName.k_FlateDecode) {
            return true;
        }
        return filterObj instanceof CosArray && ((CosArray)filterObj).size() == 1 && ((CosArray)filterObj).get(0).nameValue() == ASName.k_FlateDecode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeOut(OutputByteStream dstByteStm, boolean inString, boolean inDebugMode, boolean saveToCopy) throws PDFCosParseException, PDFIOException, IOException, PDFSecurityException {
        long initPos = this.mPos;
        boolean doDecoding = false;
        boolean doEncoding = false;
        boolean doDecryption = false;
        boolean hasAcroBug = false;
        boolean doEncryption = false;
        InputByteStream srcByteStm = null;
        InputStream srcStm = null;
        OutputStream dstStm = null;
        long initialLength = 0L;
        long lengthPosition = 0L;
        long streamLength = 0L;
        boolean emptyStream = false;
        if (inDebugMode) {
            super.writeOut(dstByteStm, inString, inDebugMode);
        } else {
            try {
                EncryptionHandlerState encryptHandle;
                if (!this.mDataInPDF && !this.mDataEncoded) {
                    this.checkOutputFilters();
                }
                CosObject inputFilterObj = this.get(ASName.k_Filter);
                if (this.mOutputFilters == null) {
                    if (this.getDocument().forceCompress()) {
                        if (inputFilterObj == null || !this.isFlateFilterObject(inputFilterObj) && !this.mDataInPDF && !this.mDataEncoded) {
                            this.setFlateOuputFilter();
                        }
                    } else if (!(inputFilterObj == null || this.isFlateFilterObject(inputFilterObj) || this.mDataInPDF || this.mDataEncoded)) {
                        this.setFlateOuputFilter();
                    }
                }
                this.mOutputFilters = this.getDocument().getEncryption().checkEFFOutputFilter(this);
                if (this.mToEncrypt) {
                    this.mOutputFilters = this.getDocument().getEncryption().checkMetadataStream(this);
                }
                if (this.mDataInPDF) {
                    initialLength = this.getLong(ASName.k_Length);
                    try {
                        srcByteStm = this.getDocument().getStream(this.mPos, initialLength);
                    }
                    catch (PDFIOException e) {
                        initialLength = CosRepairUtils.getStreamLength(this.getDocument(), this.mPos);
                        srcByteStm = this.getDocument().getStream(this.mPos, initialLength);
                        this.setRepairedValue(ASName.k_Length, this.getDocument().createCosNumeric(initialLength));
                    }
                    boolean bl = doDecryption = initialLength == 0L ? false : this.needsDecryption(srcByteStm);
                    if (this.mOutputFilters != null && this.filtersChanged(this.mOutputFilters, true)) {
                        doDecoding = true;
                        doEncoding = true;
                    }
                } else {
                    srcByteStm = this.getCachedStream(this.mDataEncoded);
                    srcByteStm = srcByteStm == null ? this.getStreamManager().getInputByteStream(new byte[0]) : srcByteStm.slice();
                    initialLength = srcByteStm.length();
                    doEncoding = !this.mDataEncoded && this.needsEncoding();
                }
                srcStm = srcByteStm.toInputStream();
                if (doDecryption && !(hasAcroBug = this.checkForAcroBug())) {
                    encryptHandle = this.getDocument().getEncryption().getStreamDecryptionStateHandler(this, srcByteStm);
                    srcStm = new DecryptingInputStream(this, srcStm, encryptHandle);
                }
                this.getCryptFilter(this.mOutputFilters);
                doEncryption = this.needsEncryption();
                if (doEncryption) {
                    encryptHandle = this.getDocument().getEncryption().getStreamEncryptionStateHandler(this);
                    dstStm = new EncryptingOutputStream(this, dstByteStm, encryptHandle);
                } else {
                    dstStm = dstByteStm.toOutputStream();
                }
                if (initialLength == 0L) {
                    doEncoding = false;
                    doDecoding = false;
                }
                if (doDecoding || doEncoding) {
                    FilterParams params;
                    ASName curFilter;
                    CosArray filterItem;
                    CosArray outFilters;
                    CosArray inFilters;
                    CosArray cosArray = inFilters = doDecoding ? this.getInputFilters(true) : this.getDocument().createCosArray();
                    if (inFilters == null) {
                        inFilters = this.getDocument().createCosArray();
                    }
                    CosArray cosArray2 = doEncoding ? (this.getOutputFiltersList() != null ? this.getOutputFiltersList() : this.getInputFilters(true)) : (outFilters = this.getDocument().createCosArray());
                    if (outFilters == null) {
                        outFilters = this.getDocument().createCosArray();
                    }
                    CosArray inFiltersTrimmed = this.getDocument().createCosArray();
                    CosArray outFiltersTrimmed = this.getDocument().createCosArray();
                    this.trimFilterLists(inFilters, outFilters, inFiltersTrimmed, outFiltersTrimmed, hasAcroBug);
                    Iterator<CosObject> filterIter = inFiltersTrimmed.iterator();
                    while (filterIter.hasNext()) {
                        filterItem = (CosArray)filterIter.next();
                        curFilter = ((CosName)filterItem.get(0)).nameValue();
                        params = FilterStream.buildFilterParams(filterItem.get(1));
                        srcStm = FilterStream.applyFilter(srcStm, curFilter, params, this.getCustomFilterRegistry());
                    }
                    if (hasAcroBug) {
                        EncryptionHandlerState encryptHandle2 = this.getDocument().getEncryption().getStreamDecryptionStateHandler(this, srcByteStm);
                        srcStm = new DecryptingInputStream(this, srcStm, encryptHandle2);
                    }
                    filterIter = outFiltersTrimmed.iterator();
                    while (filterIter.hasNext()) {
                        filterItem = (CosArray)filterIter.next();
                        curFilter = ((CosName)filterItem.get(0)).nameValue();
                        params = FilterStream.buildFilterParams(filterItem.get(1));
                        dstStm = FilterStream.applyFilter(dstStm, curFilter, params, this.getCustomFilterRegistry());
                    }
                }
                CosArray newFilters = this.mOutputFilters;
                this.mOutputFilters = null;
                if (newFilters == null && doDecryption && !doEncryption) {
                    newFilters = this.getInputFilters(true);
                }
                this.setInputFilters(newFilters);
                if (doDecoding || doEncoding || doDecryption || doEncryption) {
                    if (doEncryption && initialLength == 0L) {
                        initialLength = 1L;
                        emptyStream = true;
                    }
                    super.put(ASName.k_Length, initialLength * 1000L);
                    lengthPosition = this.writeStreamDict(dstByteStm, inString, inDebugMode);
                } else {
                    super.put(ASName.k_Length, initialLength);
                    super.writeOut(dstByteStm, inString, inDebugMode);
                }
                dstByteStm.write("stream\n".getBytes());
                this.mPos = dstByteStm.getPosition();
                try {
                    if (emptyStream) {
                        byte[] buf = new byte[]{};
                        dstStm.write(buf, 0, 0);
                    } else {
                        IO.copy(srcStm, dstStm);
                    }
                }
                catch (EOFException e) {
                }
                catch (ZipException e) {
                    throw new PDFCosParseException(e);
                }
                if (dstStm != null) {
                    dstStm.flush();
                }
            }
            finally {
                try {
                    try {
                        if (srcStm != null) {
                            srcStm.close();
                        }
                    }
                    finally {
                        try {
                            if (dstStm != null) {
                                dstStm.flush();
                            }
                        }
                        finally {
                            try {
                                if (dstStm != null) {
                                    dstStm.close();
                                }
                            }
                            finally {
                                if (srcByteStm != null) {
                                    srcByteStm.close();
                                }
                            }
                        }
                    }
                }
                catch (IOException e) {}
            }
            streamLength = dstByteStm.getPosition() - this.mPos;
            dstByteStm.write("\nendstream".getBytes());
            if (lengthPosition != 0L) {
                super.put(ASName.k_Length, streamLength);
                long savePosition = dstByteStm.getPosition();
                dstByteStm.seek(lengthPosition);
                String initialLengthString = Long.toString(initialLength * 1000L);
                String finalLengthString = Long.toString(streamLength);
                int padding = initialLengthString.length() - finalLengthString.length();
                if (padding < 0) {
                    throw new PDFIOException("CosStream length field string overflow.");
                }
                while (padding-- > 0) {
                    dstByteStm.write(32);
                }
                dstByteStm.write(StringOps.toByteArray(finalLengthString));
                dstByteStm.seek(savePosition);
            }
        }
        if (saveToCopy) {
            this.mPos = initPos;
        }
    }

    private void setInputFilters(CosArray filterList) throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        if (filterList != null && this.filtersChanged(filterList, false)) {
            CosObject outputFilter = null;
            CosObject outputParams = null;
            if (filterList.size() == 1) {
                CosArray filter = (CosArray)filterList.get(0);
                outputFilter = filter.get(0);
                outputParams = FilterStream.updateCustomFilterParams(((CosName)outputFilter).nameValue(), filter.get(1), this.getCustomFilterRegistry());
            } else if (filterList.size() != 0) {
                boolean outputParamsNull = true;
                outputFilter = this.getDocument().createCosArray();
                outputParams = this.getDocument().createCosArray();
                Iterator<CosObject> iter = filterList.iterator();
                while (iter.hasNext()) {
                    CosArray listItem = (CosArray)iter.next();
                    CosObject filter = listItem.get(0);
                    CosObject params = listItem.get(1);
                    ((CosArray)outputFilter).add(filter);
                    params = FilterStream.updateCustomFilterParams(((CosName)filter).nameValue(), params, this.getCustomFilterRegistry());
                    if (params == null) {
                        ((CosArray)outputParams).add(this.getDocument().createCosNull());
                        continue;
                    }
                    ((CosArray)outputParams).add(params);
                    outputParamsNull = false;
                }
                if (outputParamsNull) {
                    outputParams = null;
                }
            }
            super.remove(ASName.k_Filter);
            if (outputFilter != null) {
                super.put(ASName.k_Filter, outputFilter);
            }
            super.remove(ASName.k_DecodeParms);
            if (outputParams != null && !(outputParams instanceof CosNull)) {
                super.put(ASName.k_DecodeParms, outputParams);
            }
        }
    }

    private void trimFilterLists(CosArray inFilters, CosArray outFilters, CosArray inFiltersTrimmed, CosArray outFiltersTrimmed, boolean hasAcroBug) throws PDFCosParseException, IOException, PDFSecurityException, PDFIOException {
        CosArray filterItem;
        Iterator<CosObject> filterIter = inFilters.iterator();
        while (filterIter.hasNext()) {
            filterItem = (CosArray)filterIter.next();
            if (((CosName)filterItem.get(0)).nameValue() == ASName.k_Crypt) continue;
            inFiltersTrimmed.add(filterItem);
        }
        filterIter = outFilters.iterator();
        while (filterIter.hasNext()) {
            filterItem = (CosArray)filterIter.next();
            if (((CosName)filterItem.get(0)).nameValue() == ASName.k_Crypt) continue;
            outFiltersTrimmed.add(filterItem);
        }
        if (hasAcroBug) {
            return;
        }
        while (!inFiltersTrimmed.isEmpty() && !outFiltersTrimmed.isEmpty()) {
            CosArray inFilterItemLast = (CosArray)inFiltersTrimmed.get(inFiltersTrimmed.size() - 1);
            CosArray outFilterItemLast = (CosArray)outFiltersTrimmed.get(outFiltersTrimmed.size() - 1);
            if (((CosName)inFilterItemLast.get(0)).nameValue() != ((CosName)outFilterItemLast.get(0)).nameValue() || !inFilterItemLast.get(1).equals(outFilterItemLast.get(1))) break;
            inFiltersTrimmed.remove(inFiltersTrimmed.size() - 1);
            outFiltersTrimmed.remove(outFiltersTrimmed.size() - 1);
        }
    }

    private long writeStreamDict(OutputByteStream outStream, boolean inString, boolean inDebugMode) throws PDFCosParseException, IOException, PDFSecurityException, PDFIOException {
        long lengthPosition = 0L;
        outStream.write(60);
        outStream.write(60);
        for (Map.Entry entry : this.mData.entrySet()) {
            ASName key = (ASName)entry.getKey();
            key.write(outStream);
            CosObject value = (CosObject)entry.getValue();
            if (value.isIndirect() || value instanceof CosBoolean || value instanceof CosNumeric || value instanceof CosNull) {
                outStream.write(32);
            }
            if (key == ASName.k_Length) {
                lengthPosition = outStream.getPosition();
            }
            value.writeOut(outStream, inString, inDebugMode);
        }
        outStream.write(62);
        outStream.write(62);
        return lengthPosition;
    }

    private CustomFilterRegistry getCustomFilterRegistry() {
        return this.getDocument().getOptions().getCustomFilterRegistry();
    }

    @Override
    public boolean equals(CosObject value) {
        HashMap<Integer, HashSet<Integer>> alreadyComparedCosObjectPairsList = new HashMap<Integer, HashSet<Integer>>();
        return this.safeEquals(value, alreadyComparedCosObjectPairsList);
    }

    @Override
    boolean safeEquals(CosObject value, HashMap<Integer, HashSet<Integer>> alreadyComparedCosObjectPairsList) {
        if (!(value instanceof CosStream) || value.getDocument() != this.getDocument()) {
            return false;
        }
        if (value == this) {
            return true;
        }
        if (this.cosObjectPairAlreadyInList(new Integer[]{this.getObjNum(), value.getObjNum()}, alreadyComparedCosObjectPairsList) == 0) {
            return true;
        }
        CosStream valueStream = (CosStream)value;
        if (!super.safeEquals(valueStream, alreadyComparedCosObjectPairsList)) {
            return false;
        }
        try {
            return Arrays.equals(CosUtils.digestStream(valueStream.getStreamDecoded(), "SHA-1"), CosUtils.digestStream(this.getStreamDecoded(), "SHA-1"));
        }
        catch (Exception e) {
            throw new RuntimeException("problem occured while equating " + valueStream.getObjNum() + " with " + this.getObjNum(), e);
        }
    }

    public boolean isEncoded() throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        if (this.mDataInPDF) {
            return this.needsDecoding(false);
        }
        return this.mDataEncoded;
    }
}

