/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.composite;

import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.DefaultValidator;
import org.apache.jackrabbit.oak.spi.commit.EditorProvider;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.mount.Mount;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.mount.Mounts;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ComponentPropertyType;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class PrivateStoreValidatorProvider
extends ValidatorProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String ROOT_PATH = "/";
    private boolean failOnDetection;
    private MountInfoProvider mountInfoProvider = Mounts.defaultMountInfoProvider();
    private ServiceRegistration serviceRegistration;

    @Override
    @NotNull
    public Validator getRootValidator(NodeState before, NodeState after, CommitInfo info) {
        return new PrivateStoreValidator(ROOT_PATH);
    }

    @Activate
    private void activate(BundleContext bundleContext, Config config) {
        this.failOnDetection = config.failOnDetection();
        if (this.mountInfoProvider.hasNonDefaultMounts()) {
            this.serviceRegistration = bundleContext.registerService(EditorProvider.class.getName(), (Object)this, null);
            this.logger.info("Enabling PrivateStoreValidatorProvider with failOnDetection {}", (Object)this.failOnDetection);
        }
    }

    @Deactivate
    private void deactivate() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
    }

    void setMountInfoProvider(MountInfoProvider mountInfoProvider) {
        this.mountInfoProvider = mountInfoProvider;
    }

    void setFailOnDetection(boolean failOnDetection) {
        this.failOnDetection = failOnDetection;
    }

    boolean isFailOnDetection() {
        return this.failOnDetection;
    }

    @Reference(name="mountInfoProvider", service=MountInfoProvider.class)
    protected void bindMountInfoProvider(MountInfoProvider mip) {
        this.mountInfoProvider = mip;
    }

    protected void unbindMountInfoProvider(MountInfoProvider mip) {
        if (this.mountInfoProvider == mip) {
            this.mountInfoProvider = null;
        }
    }

    private class PrivateStoreValidator
    extends DefaultValidator {
        private final String path;

        public PrivateStoreValidator(String path) {
            this.path = path;
        }

        @Override
        public Validator childNodeAdded(String name, NodeState after) throws CommitFailedException {
            return this.checkPrivateStoreCommit(this.getCommitPath(name));
        }

        @Override
        public Validator childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
            return this.checkPrivateStoreCommit(this.getCommitPath(name));
        }

        @Override
        public Validator childNodeDeleted(String name, NodeState before) throws CommitFailedException {
            return this.checkPrivateStoreCommit(this.getCommitPath(name));
        }

        private Validator checkPrivateStoreCommit(String commitPath) throws CommitFailedException {
            Mount mountInfo = PrivateStoreValidatorProvider.this.mountInfoProvider.getMountByPath(commitPath);
            if (mountInfo.isReadOnly()) {
                Throwable throwable = new Throwable("Commit path: " + commitPath);
                PrivateStoreValidatorProvider.this.logger.error("Detected commit to a read-only store! ", throwable);
                if (PrivateStoreValidatorProvider.this.failOnDetection) {
                    throw new CommitFailedException("Unsupported", 0, "Unsupported commit to a read-only store!", throwable);
                }
            }
            return new PrivateStoreValidator(commitPath);
        }

        private String getCommitPath(String changeNodeName) {
            return PathUtils.concat(this.path, changeNodeName);
        }
    }

    @ComponentPropertyType
    static @interface Config {
        @AttributeDefinition(name="Fail when detecting commits to the read-only stores", description="Commits will fail if set to true when detecting changes to any read-only store. If set to false the commit information is only logged.")
        public boolean failOnDetection() default true;
    }
}

