/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.jcr.Repository;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.collect.Sets;
import org.apache.jackrabbit.oak.Oak;
import org.apache.jackrabbit.oak.api.ContentRepository;
import org.apache.jackrabbit.oak.jcr.repository.RepositoryImpl;
import org.apache.jackrabbit.oak.plugins.commit.JcrConflictHandler;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.observation.CommitRateLimiter;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CompositeConflictHandler;
import org.apache.jackrabbit.oak.spi.commit.ConflictHandlers;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorProvider;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.commit.PartialConflictHandler;
import org.apache.jackrabbit.oak.spi.commit.ThreeWayConflictHandler;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.query.QueryLimits;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.state.Clusterable;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.jetbrains.annotations.NotNull;

public class Jcr {
    public static final int DEFAULT_OBSERVATION_QUEUE_LENGTH = 10000;
    private final Oak oak;
    private final Set<RepositoryInitializer> repositoryInitializers = Sets.newLinkedHashSet();
    private final Set<QueryIndexProvider> queryIndexProviders = Sets.newLinkedHashSet();
    private final Set<CommitHook> commitHooks = Sets.newLinkedHashSet();
    private final Set<IndexEditorProvider> indexEditorProviders = Sets.newLinkedHashSet();
    private final Set<EditorProvider> editorProviders = Sets.newLinkedHashSet();
    private final Set<Editor> editors = Sets.newLinkedHashSet();
    private final Set<Observer> observers = Sets.newLinkedHashSet();
    private final CompositeConflictHandler conflictHandler = JcrConflictHandler.createJcrConflictHandler();
    private SecurityProvider securityProvider;
    private CommitRateLimiter commitRateLimiter;
    private ScheduledExecutorService scheduledExecutor;
    private Executor executor;
    private QueryLimits queryEngineSettings;
    private String defaultWorkspaceName;
    private Whiteboard whiteboard;
    private int observationQueueLength = 10000;
    private boolean fastQueryResultSize;
    private boolean createSessionMBeans = true;
    private ContentRepository contentRepository;
    private Repository repository;
    private Clusterable clusterable;

    public Jcr(Oak oak, boolean initialize) {
        this.oak = oak;
        if (initialize) {
            Oak.OakDefaultComponents defs = new Oak.OakDefaultComponents();
            this.with(defs.securityProvider());
            for (CommitHook ch : defs.commitHooks()) {
                this.with(ch);
            }
            for (RepositoryInitializer ri : defs.repositoryInitializers()) {
                this.with(ri);
            }
            for (EditorProvider ep : defs.editorProviders()) {
                this.with(ep);
            }
            for (IndexEditorProvider iep : defs.indexEditorProviders()) {
                this.with(iep);
            }
            for (QueryIndexProvider qip : defs.queryIndexProviders()) {
                this.with(qip);
            }
        }
    }

    public Jcr(Oak oak) {
        this(oak, true);
    }

    public Jcr() {
        this(new Oak());
    }

    public Jcr(NodeStore store) {
        this(new Oak(store));
    }

    @NotNull
    public Jcr with(@NotNull Clusterable c) {
        this.ensureRepositoryIsNotCreated();
        this.clusterable = Objects.requireNonNull(c);
        return this;
    }

    @NotNull
    public final Jcr with(@NotNull RepositoryInitializer initializer) {
        this.ensureRepositoryIsNotCreated();
        this.repositoryInitializers.add(Objects.requireNonNull(initializer));
        return this;
    }

    public Jcr withAtomicCounter() {
        this.ensureRepositoryIsNotCreated();
        this.oak.withAtomicCounter();
        return this;
    }

    private void ensureRepositoryIsNotCreated() {
        Preconditions.checkState((this.repository == null && this.contentRepository == null ? 1 : 0) != 0, (Object)"Repository was already created");
    }

    @NotNull
    public final Jcr with(@NotNull QueryIndexProvider provider) {
        this.ensureRepositoryIsNotCreated();
        this.queryIndexProviders.add(Objects.requireNonNull(provider));
        return this;
    }

    @NotNull
    public final Jcr with(@NotNull IndexEditorProvider indexEditorProvider) {
        this.ensureRepositoryIsNotCreated();
        this.indexEditorProviders.add(Objects.requireNonNull(indexEditorProvider));
        return this;
    }

    @NotNull
    public final Jcr with(@NotNull CommitHook hook) {
        this.ensureRepositoryIsNotCreated();
        this.commitHooks.add(Objects.requireNonNull(hook));
        return this;
    }

    @NotNull
    public final Jcr with(@NotNull EditorProvider provider) {
        this.ensureRepositoryIsNotCreated();
        this.editorProviders.add(Objects.requireNonNull(provider));
        return this;
    }

    @NotNull
    public final Jcr with(@NotNull Editor editor) {
        this.ensureRepositoryIsNotCreated();
        this.editors.add(Objects.requireNonNull(editor));
        return this;
    }

    @NotNull
    public final Jcr with(@NotNull SecurityProvider securityProvider) {
        this.ensureRepositoryIsNotCreated();
        this.securityProvider = Objects.requireNonNull(securityProvider);
        return this;
    }

    @Deprecated
    @NotNull
    public final Jcr with(@NotNull PartialConflictHandler conflictHandler) {
        return this.with(ConflictHandlers.wrap(conflictHandler));
    }

    @NotNull
    public final Jcr with(@NotNull ThreeWayConflictHandler conflictHandler) {
        this.ensureRepositoryIsNotCreated();
        this.conflictHandler.addHandler(Objects.requireNonNull(conflictHandler));
        return this;
    }

    @NotNull
    public final Jcr with(@NotNull ScheduledExecutorService executor) {
        this.ensureRepositoryIsNotCreated();
        this.scheduledExecutor = Objects.requireNonNull(executor);
        return this;
    }

    @NotNull
    public final Jcr with(@NotNull Executor executor) {
        this.ensureRepositoryIsNotCreated();
        this.executor = Objects.requireNonNull(executor);
        return this;
    }

    @NotNull
    public final Jcr with(@NotNull Observer observer) {
        this.ensureRepositoryIsNotCreated();
        this.observers.add(Objects.requireNonNull(observer));
        return this;
    }

    @Deprecated
    @NotNull
    public Jcr withAsyncIndexing() {
        this.ensureRepositoryIsNotCreated();
        this.oak.withAsyncIndexing();
        return this;
    }

    @NotNull
    public Jcr withAsyncIndexing(@NotNull String name, long delayInSeconds) {
        this.ensureRepositoryIsNotCreated();
        this.oak.withAsyncIndexing(name, delayInSeconds);
        return this;
    }

    @NotNull
    public Jcr withObservationQueueLength(int observationQueueLength) {
        this.ensureRepositoryIsNotCreated();
        this.observationQueueLength = observationQueueLength;
        return this;
    }

    @NotNull
    public Jcr with(@NotNull CommitRateLimiter commitRateLimiter) {
        this.ensureRepositoryIsNotCreated();
        this.commitRateLimiter = Objects.requireNonNull(commitRateLimiter);
        return this;
    }

    @NotNull
    public Jcr with(@NotNull QueryLimits qs) {
        this.ensureRepositoryIsNotCreated();
        this.queryEngineSettings = Objects.requireNonNull(qs);
        return this;
    }

    @NotNull
    public Jcr withFastQueryResultSize(boolean fastQueryResultSize) {
        this.ensureRepositoryIsNotCreated();
        this.fastQueryResultSize = fastQueryResultSize;
        return this;
    }

    @NotNull
    public Jcr with(@NotNull String defaultWorkspaceName) {
        this.ensureRepositoryIsNotCreated();
        this.defaultWorkspaceName = Objects.requireNonNull(defaultWorkspaceName);
        return this;
    }

    @NotNull
    public Jcr with(@NotNull Whiteboard whiteboard) {
        this.ensureRepositoryIsNotCreated();
        this.whiteboard = Objects.requireNonNull(whiteboard);
        return this;
    }

    @NotNull
    public Jcr withoutSessionMBeans() {
        this.createSessionMBeans = false;
        return this;
    }

    private void setUpOak() {
        if (this.whiteboard != null) {
            this.oak.with(this.whiteboard);
        }
        for (RepositoryInitializer repositoryInitializer : this.repositoryInitializers) {
            this.oak.with(repositoryInitializer);
        }
        for (QueryIndexProvider queryIndexProvider : this.queryIndexProviders) {
            this.oak.with(queryIndexProvider);
        }
        for (CommitHook commitHook : this.commitHooks) {
            this.oak.with(commitHook);
        }
        this.oak.with(this.conflictHandler);
        for (IndexEditorProvider indexEditorProvider : this.indexEditorProviders) {
            this.oak.with(indexEditorProvider);
        }
        for (Editor editor : this.editors) {
            this.oak.with(editor);
        }
        for (EditorProvider editorProvider : this.editorProviders) {
            this.oak.with(editorProvider);
        }
        this.oak.with(this.securityProvider);
        if (this.scheduledExecutor != null) {
            this.oak.with(this.scheduledExecutor);
        }
        if (this.executor != null) {
            this.oak.with(this.executor);
        }
        for (Observer observer : this.observers) {
            this.oak.with(observer);
        }
        if (this.commitRateLimiter != null) {
            this.oak.with(this.commitRateLimiter);
        }
        if (this.queryEngineSettings != null) {
            this.oak.with(this.queryEngineSettings);
        }
        if (this.defaultWorkspaceName != null) {
            this.oak.with(this.defaultWorkspaceName);
        }
        if (this.clusterable != null) {
            this.oak.with(this.clusterable);
        }
    }

    @NotNull
    public ContentRepository createContentRepository() {
        if (this.contentRepository == null) {
            this.setUpOak();
            this.contentRepository = this.oak.createContentRepository();
        }
        return this.contentRepository;
    }

    @NotNull
    public Repository createRepository() {
        if (this.repository == null) {
            this.repository = new RepositoryImpl(this.createContentRepository(), this.oak.getWhiteboard(), this.securityProvider, this.observationQueueLength, this.commitRateLimiter, this.fastQueryResultSize, this.createSessionMBeans);
        }
        return this.repository;
    }
}

