/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.util;

import java.util.Objects;
import java.util.Set;
import org.apache.jackrabbit.oak.plugins.index.IndexUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.LuceneIndexHelper;
import org.apache.jackrabbit.oak.plugins.index.search.util.IndexHelper;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.jetbrains.annotations.NotNull;

public class LuceneInitializerHelper
implements RepositoryInitializer {
    private final String name;
    private final Set<String> propertyTypes;
    private final Set<String> excludes;
    private final String filePath;
    private String async = null;
    private Boolean storageEnabled;

    public LuceneInitializerHelper(String name) {
        this(name, IndexHelper.JR_PROPERTY_INCLUDES, null, null, null);
    }

    public LuceneInitializerHelper(String name, Boolean storageEnabled) {
        this(name, IndexHelper.JR_PROPERTY_INCLUDES, null, null, storageEnabled);
    }

    public LuceneInitializerHelper(String name, Set<String> propertyTypes) {
        this(name, propertyTypes, null, null, null);
    }

    public LuceneInitializerHelper(String name, Set<String> propertyTypes, Set<String> excludes) {
        this(name, propertyTypes, excludes, null, null);
    }

    public LuceneInitializerHelper(String name, Set<String> propertyTypes, String filePath) {
        this(name, propertyTypes, null, filePath, null);
    }

    public LuceneInitializerHelper(String name, Set<String> propertyTypes, Set<String> excludes, String filePath, Boolean storageEnabled) {
        this.name = name;
        this.propertyTypes = propertyTypes;
        this.excludes = excludes;
        this.filePath = filePath;
        this.storageEnabled = storageEnabled;
    }

    public LuceneInitializerHelper async() {
        return this.async("async");
    }

    public LuceneInitializerHelper async(@NotNull String async) {
        this.async = Objects.requireNonNull(async);
        return this;
    }

    @Override
    public void initialize(@NotNull NodeBuilder builder) {
        if (!builder.hasChildNode("oak:index") || !builder.getChildNode("oak:index").hasChildNode(this.name)) {
            if (this.filePath == null) {
                LuceneIndexHelper.newLuceneIndexDefinition(IndexUtils.getOrCreateOakIndex(builder), this.name, this.propertyTypes, this.excludes, this.async, this.storageEnabled);
            } else {
                LuceneIndexHelper.newLuceneFileIndexDefinition(IndexUtils.getOrCreateOakIndex(builder), this.name, this.propertyTypes, this.excludes, this.filePath, this.async);
            }
        }
    }
}

