/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
/**
 * AdobePatentID="3435US01"
 */
package com.adobe.cq.launches.api;

import org.apache.sling.api.resource.Resource;

/**
 * Launch promotion parameters.
 */
public interface LaunchPromotionParameters {

    /**
     * Get the resource to promote (within the launch tree)
     *
     * @return The resource to promote
     */
    public Resource getResource();

    /**
     * Get the promotion scope, which determines which content needs to be
     * promoted
     *
     * @return The promotion scope
     */
    public LaunchPromotionScope getPromotionScope();

    /**
     * A launch can be promoted either to the production version or to one of its parent launches (if it
     * is a nested launch). This method returns the parent launch to be targeted by the promotion, or
     * <code>null</code> if the launch should be promoted to the production version.
     *
     * @return The target launch or <code>null</code>
     */
    public Launch getTarget();

    /**
     * Get the resource collection (workflow package) the resource should be
     * added to
     *
     * @return The resource collection or <code>null</code> if not specified
     */
    public String getResourceCollectionPath();

}
