/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/
package com.adobe.cq.sites.ui.models;

import com.day.cq.commons.jcr.JcrConstants;
import com.petebevin.markdown.MarkdownProcessor;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.PostConstruct;
import java.io.InputStream;

@Model(adaptables = SlingHttpServletRequest.class)
public class ComponentModel {

    private static final Logger LOG = LoggerFactory.getLogger(ComponentModel.class);

    private static final String NN_DOCUMENTATION = "README.md";

    @Self
    SlingHttpServletRequest request;

    private String description;
    private String documentation;

    @PostConstruct
    public void postConstruct() throws Exception {
        String suffix = request.getRequestPathInfo().getSuffix();
        if (suffix == null) {
            LOG.error("Missing request suffix");
            return;
        }

        ResourceResolver resolver = request.getResourceResolver();
        Resource resource = resolver.getResource(suffix);
        if (resource == null) {
            LOG.error("Provided suffix doesn't map to a resource: {}", suffix);
            return;
        }

        ValueMap properties = resource.adaptTo(ValueMap.class);
        description = properties.get(JcrConstants.JCR_DESCRIPTION, String.class);

        Resource documentationResource = resource.getChild(NN_DOCUMENTATION);
        if (documentationResource != null) {
            // Read the content of the file
            Resource docFile = documentationResource.getChild(JcrConstants.JCR_CONTENT);
            if (docFile != null) {
                ValueMap vm = docFile.adaptTo(ValueMap.class);
                InputStream inputStream = vm.get(JcrConstants.JCR_DATA, InputStream.class);
                String content = IOUtils.toString(inputStream);
                MarkdownProcessor mp = new MarkdownProcessor();
                documentation = mp.markdown(content);
            } else {
                LOG.error("Could not read documentation file contents: {}", documentationResource.getPath());
            }
        }
    }

    public String getDescription() {
        return description;
    }

    public String getDocumentation() {
        return documentation;
    }

}
