/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/
package com.adobe.cq.sites.ui.models.admin.security;

import com.adobe.granite.ui.components.Value;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.RequestAttribute;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.jcr.Node;
import javax.jcr.RepositoryException;

/**
 * Representation of the authentication requirement field, used to force authentication to access a given content resource.
 *
 * The authentication requirement could be enabled / disabled from the UI (for instance in the page properties view)
 *
 * The content resource is derived from the content path attribute of the request.
 */
@Model(adaptables = SlingHttpServletRequest.class)
public final class AuthRequirement {

    private static final String MN_AUTHENTICATION_REQUIRED = "granite:AuthenticationRequired";

    @Self
    private SlingHttpServletRequest slingRequest;

    @Inject
    @SlingObject
    private Resource resource;

    @Inject
    private ResourceResolver resolver;

    @RequestAttribute(optional = true, name = Value.CONTENTPATH_ATTRIBUTE)
    private String contentPath;

    @ValueMapValue(optional = true, name = "text")
    private String label;

    @ValueMapValue(optional = true, name = "fieldDescription")
    private String description;

    private boolean isAuthRequired = false;

    @PostConstruct
    protected void initModel() throws RepositoryException {
        if (contentPath != null) {
            Resource contentResource = resolver.getResource(contentPath);

            if (contentResource != null) {
                Node node = contentResource.adaptTo(Node.class);    // node is the jcr:content node
                Node parentNode = node.getParent();                 // parentNode is the Page node
                isAuthRequired = (parentNode != null) && parentNode.isNodeType(MN_AUTHENTICATION_REQUIRED);
            }
        }
    }

    /**
     * Indicates if there is authentication required to access the content resource
     * @return
     */
    public boolean isAuthRequired() {
        return isAuthRequired;
    }

    /**
     * Returns the label of the authentication requirement field
     * @return
     */
    public String getLabel() {
        return label;
    }

    /**
     * Returns the description of the authentication requirement field
     * @return
     */
    public String getDescription() {
        return description;
    }
}

