/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.wcm.style;

import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.osgi.annotation.versioning.ProviderType;

/**
 * A {@code ContentPolicyStyleInfo} provides methods for retrieving information about the styles defined at the
 * content policy of a component.
 *
 * @since com.adobe.cq.wcm.style 1.0.0
 */
@ProviderType
public interface ContentPolicyStyleInfo {

    /**
     * Retrieves the list of style groups defined at the content policy of a component.
     *
     * @return the list of the style groups if any, an empty list otherwise
     * @since com.adobe.cq.wcm.style 1.0.0
     */
    @Nonnull
    List<StyleGroupInfo> getStyleGroups();

    /**
     * Retrieves the default CSS classes defined at the content policy of a component.
     *
     * @return the CSS classes if defined, {@code null} otherwise
     * @since com.adobe.cq.wcm.style 2.1.0
     */
    @Nullable
    String getDefaultCssClasses();

    /**
     * Retrieves the default HTML element that is applied at the content policy of a component.
     *
     * @return the HTML element if defined, {@code null} otherwise
     * @since com.adobe.cq.wcm.style 2.1.0
     */
    @Nullable
    String getDefaultHtmlElement();

}