/*******************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 * <p/>
 * Copyright 2016 Adobe Systems Incorporated
 * All Rights Reserved.
 * <p/>
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/

package com.adobe.cq.xf;

import org.osgi.annotation.versioning.ProviderType;
import com.day.cq.wcm.webservicesupport.Configuration;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.ValueMap;

import java.util.List;

/**
 * Model object that represents an experience fragment. This experience fragment can have multiple variations
 */
@ProviderType
public interface ExperienceFragment extends Adaptable {

    /**
     * Retrieves all the variations of this experience fragment.
     * @return a list of {@link ExperienceFragmentVariation} objects. If the experience fragment has no variations then an emtpy list is returned.
     */
    List<ExperienceFragmentVariation> getVariations();

    /**
     * Retrieves all the variations of this experience fragment, filtered by one or more types
     * @param type the type(s) of variations to be retrieved
     * @return a list of {@link ExperienceFragmentVariation} objects. If the experience fragment has no variations of the specified type(s) then an empty list is returned.
     */
    List<ExperienceFragmentVariation> getVariations(String... type);

    /**
     * Retrieves the path of this experience fragment
     * @return the path of the variation page
     */
    String getPath();

    /**
     * Retrieves the properties of this experience fragment
     * @return a {@link ValueMap} object
     */
    ValueMap getProperties();


    /**
     * Retrieves a list of cloud services configurations attached to this experience fragment
     * @return a list of {@link Configuration} objects pointing to their respective cloud service configurations
     */
    List<String> getCloudserviceConfigurationsPaths();



}
