/**
 * 
 */
package com.adobe.fontengine.font.mac;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.WrapperFontData;
import com.adobe.fontengine.fontmanagement.Platform;
import com.adobe.fontengine.fontmanagement.fxg.FXGFontDescription;
import com.adobe.fontengine.fontmanagement.platform.PlatformFontDescription;


/**
 * A wrapper for Mac Resource font file fonts.
 *
 */
public class ResourceFontData extends WrapperFontData 
{
	private String rsrcFontName;
	private String sfntName;
	private ULocale locale;
	private boolean isBold;
	private boolean isItalic;

	/**
	 * @param fontData the actual font data
	 * @param locale the locale of this wrapper
	 * @param fontName the font name for this wrapper
	 * @param isBold is the wrapper bold
	 * @param isItalic is the wrapper italic
	 */
	public ResourceFontData(FontData fontData, ULocale locale, String fontName, String sfntName, boolean isBold, boolean isItalic) 
	{
		super(fontData);
		this.locale = locale;
		this.rsrcFontName = fontName;
		this.sfntName = sfntName;
		this.isBold = isBold;
		this.isItalic = isItalic;
	}

	public FXGFontDescription[] getFXGFontDescription(Platform platform, ULocale locale)
	throws InvalidFontException, UnsupportedFontException 
	{
		if ((platform == Platform.MAC_OSX || platform == null) && this.locale != null && this.rsrcFontName != null && isContainedWithin(this.locale, locale))
		{
			FXGFontDescription[] fxgDesc = new FXGFontDescription[] {
					new FXGFontDescription(Platform.MAC_OSX, this.locale, this.rsrcFontName, this.isBold, this.isItalic)
			};
			return fxgDesc;
		}
		return new FXGFontDescription[0];
	}
	
	public PlatformFontDescription[] getPlatformFontDescription(Platform platform, ULocale locale)
	throws InvalidFontException, UnsupportedFontException 
	{
		PlatformFontDescription[] platformDesc = this.getFontData().getPlatformFontDescription(platform, locale);
		if (platformDesc != null)
		{
			return platformDesc;
		}
		
		if ((platform == Platform.MAC_OSX || platform == null) && this.locale != null && this.sfntName != null && isContainedWithin(this.locale, locale))
		{
			platformDesc = new PlatformFontDescription[] {
					new PlatformFontDescription(Platform.MAC_OSX, this.locale, this.sfntName)
			};
			return platformDesc;
		}
		return new PlatformFontDescription[0];
	}
	
	/**
	 * Check whether this <code>LanguageCodeEntry</code> is contained within the given <b>ULocale</b>.
	 * It is contained within the other locale if this entry is equal to the locale or if this entry
	 * is a "tighter" locale specification than the given local.  For example, "en_CA" is contained
	 * within "en" and "mn_MN_Cyrl" is contained within "mn_MN".  However, "zh_SG" is <b>not</b>
	 * contained within "zh_TW".
	 * 
	 * This is also used in the opentype.Name class.  Should be moved off to Rideau
	 * but will require that Rideau start using AGL.
	 * 
	 * @param baseLocale the locale to check against for containment
	 * @param locale the locale to check if it is withing the baseLocale
	 * @return <code>true</code> if this entry defines a locale that is contained within the given locale; 
	 * <code>false</code> otherwise
	 */
	private static boolean isContainedWithin(ULocale baseLocale, ULocale locale)
	{
		if (locale == null)
		{
			return true;
		}
		
		// language
		String baseLanguage = baseLocale.getLanguage();
		if ((baseLanguage != null && !baseLanguage.equals("")) && !baseLanguage.equals(locale.getLanguage()))
		{
			return false;
		}

		// country
		String baseCountry = baseLocale.getCountry();
		if ((baseCountry != null && !baseCountry.equals("")) && !baseCountry.equals(locale.getCountry()))
		{
			return false;
		}

		// script
		String baseScript = baseLocale.getScript();
		if ((baseScript != null && baseScript.equals("")) && !baseScript.equals(locale.getScript()))
		{
			return false;
		}

		return true;
	}

}
