package com.adobe.fontengine.fontmanagement;

import java.io.Serializable;


/**
 * This class provides an enumeration of the supported platforms.
 * 
 * <h4>Concurrency</h4>
 * 
 * Instances of this class are immutable after construction and contain no mutable static
 * data. Therefore, they are threadsafe.
 */
public final class Platform implements Serializable
{
	public static final Platform UNKNOWN = new Platform("Unknown");
	public static final Platform MAC_OSX = new Platform("Mac OS X");
	public static final Platform WINDOWS = new Platform("Windows");
	
	private static final Platform[] platforms = {
		MAC_OSX,
		WINDOWS
	};

	/* Serialization signature is explicitly set and should be 
	 * incremented on each release to prevent compatibility.
	 */
	static final long serialVersionUID = 1;

	private String name;

	private Platform (String name) 
	{
		// this class provides an enum
		this.name = name;
	}

	public String toString()
	{
		return name;
	}

	// This is required to maintain the enum property through serialization
	private Object readResolve()
	{
		return parse(this.name);
	}

	/**
	 * Parse the text and return the Platform object which is represented if any.
	 * 
	 * @param text textual representation of the platform
	 * @return Platform represented by the text value
	 */
	public static Platform parse(String text)
	{
		for (int i = 0; i < platforms.length; i++)
		{
			if (platforms[i].name.equalsIgnoreCase(text))
			{
				return platforms[i];
			}
		}
		return null;
	}
	
	// TODO add iterator
}
