/*************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 * Copyright 2014 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/

package com.adobe.granite.translation.api;

import java.util.List;

import com.adobe.granite.translation.api.TranslationConstants.TranslationMethod;
import org.apache.sling.api.resource.Resource;
import org.osgi.annotation.versioning.ConsumerType;

//
/**
 * The TranslationServiceFactory is responsible for creating TranslationService objects for a specific connector. It
 * also registers the connector with the TranslationManager using a unique identifier ("Name").
 */
@ConsumerType
public interface TranslationServiceFactory {

    /**
     * @deprecated  since 2.4.0, use {@link #createTranslationService(TranslationMethod, String, Resource)} instead.
     * Creates a new TranslationService object specific to this Factory.
     * @param translationMethod Specify which type of Translation service to create based on Translation Method
     * @param cloudConfigPath The path to cloud config file.
     * @return A TranslationService instance for the given factory.
     * @throws TranslationException the translation exception
     */
    @Deprecated
    TranslationService createTranslationService(TranslationMethod translationMethod, String cloudConfigPath)
        throws TranslationException;

    /**
     * Creates a new TranslationService object specific to this Factory.
     * @param translationMethod Specify which type of Translation service to create based on Translation Method
     * @param cloudConfigPath The path to cloud config file.
     * @param resource Context resource to fetch configuration for
     * @return A TranslationService instance for the given factory.
     * @throws TranslationException the translation exception
     */
    default TranslationService createTranslationService(TranslationMethod translationMethod, String cloudConfigPath, Resource resource)
        throws TranslationException {
        return createTranslationService(translationMethod, cloudConfigPath);
    }

    /**
     * Get the supported translation methods.
     * @return List of Translation method of the service property indicating the particular translation method this
     *         factory provides, e.g. machine translation or human translation.
     */
    List<TranslationMethod> getSupportedTranslationMethods();

    /**
     * Gets the service factory name.
     * @return Name of the service property indicating the particular implementation this factory provides, e.g.
     *         adobe.
     */
    String getServiceFactoryName();

    /**
     * Gets the service Cloud Config Class.
     * @return Class of the service Cloud Config. This class name will be used to determine the cloud config for the
     *         Translation service.
     */
    Class<?> getServiceCloudConfigClass();

    /**
     * Unique name of the service property indicating the particular implementation this factory provides, e.g.
     * microsoft.
     */
    static final String PROPERTY_TRANSLATION_FACTORY = "translationFactory";
}