/*************************************************************************
* ADOBE CONFIDENTIAL
* ___________________
*
* Copyright 2015 Adobe
* All Rights Reserved.
*
* NOTICE: All information contained herein is, and remains
* the property of Adobe and its suppliers, if any. The intellectual
* and technical concepts contained herein are proprietary to Adobe
* and its suppliers and are protected by all applicable intellectual
* property laws, including trade secret and copyright laws.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe.
**************************************************************************/
package com.adobe.granite.ui.components;

import java.util.HashMap;

import javax.annotation.Nonnull;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;

/**
 * A resource wrapper that wraps an underlying resource with an empty
 * {@link ValueMap}}, which can be modified accordingly. It is used for the
 * scenario where we want to control the ValueMap returned by a resource.
 */
public class ValueMapResourceWrapper extends ResourceWrapper {

    private ValueMap vm = new ValueMapDecorator(new HashMap<String, Object>());
    private String resourceType;

    /**
     * Instantiates a new wrapper.
     *
     * @param resource
     *            The resource to wrap
     * @param resourceType
     *            The resource type of the resource wrapper
     */
    public ValueMapResourceWrapper(@Nonnull Resource resource, String resourceType) {
        super(resource);
        this.resourceType = resourceType;
        vm.put("sling:resourceType", resourceType);
    }

    @Override
    public String getResourceType() {
        return resourceType;
    }

    @Override
    @SuppressWarnings("unchecked")
    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (ValueMap.class.equals(type)) {
            return (AdapterType) vm;
        } else {
            return super.adaptTo(type);
        }
    }

    @Override
    public ValueMap getValueMap() {
        return vm;
    }
}
