/*
 * File: PrivateKeyHolderFactory.java
 *  
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 * ***************************************************************************/

package com.adobe.internal.pdftoolkit.core.credentials;

import java.security.PrivateKey;

import com.adobe.internal.pdftoolkit.core.credentials.impl.ByteArrayKeyHolder;
import com.adobe.internal.pdftoolkit.core.credentials.impl.JCEKeyHolder;

/**
 * PrivateKeyHolderFactory creates a PrivateKey that can be used to create the appropriate Gibson Credentials.
 * PrivateKeys can be constructed from a set of bytes representing the key and the key wrapping format, or
 * can be an HSM private key that contains a JSAFE Session Spec and a JSAFEPrivate key, or
 * a JCE private key.
 *  * 
 * @author mdharan
 *
 */
public class PrivateKeyHolderFactory 
{
	private PrivateKeyHolderFactory () {}
	
	
	/**
	 * Creates a new instance of the PrivateKeyHolderFactory.
	 *
	 */
	public static PrivateKeyHolderFactory newInstance()
	{
		return new PrivateKeyHolderFactory();
	}

	/**
	 * Creates a PrivateKeyHolder containing bytes representing the DER encoded PKCS8 unencrypted private key and the key wrapping format.
	 * @param derEncodedPrivateKey 
	 * @param algorithm - representing the wrapping format of the key - RSA/DSA
	 * @return PrivateKeyHolder
	 */
	public PrivateKeyHolder createPrivateKey(byte[] derEncodedPrivateKey, String algorithm) 
	{
		return new ByteArrayKeyHolder(derEncodedPrivateKey,algorithm);
		
	}

	/**
	 * Creates a PrivateKeyHolder that contains a JCE PrivateKey and a provider name.
	 * @param privateKey 
	 * @param providerName (Optional) Pass in if HSM provider or a specific provider has the private key 
	 * @return PrivateKeyHolder
	 */
	public PrivateKeyHolder createPrivateKey(PrivateKey privateKey, String providerName)
	{
		return new JCEKeyHolder(privateKey,providerName);
	}


}
